<?php
if (!isset($booking) || !isset($site_settings)) { die('Required data is missing.'); }

// --- LOGIC TO DETERMINE LAYOUT ---
$departure_datetime = new DateTime($booking['departure_date'] . ' 00:00:00', new DateTimeZone('Asia/Manila'));
$now = new DateTime("now", new DateTimeZone('Asia/Manila'));
$interval = $now->diff($departure_datetime);

// Calculate total hours until departure. If the flight is in the past, treat it as 0.
$hours_until_departure = ($interval->days * 24) + $interval->h;
if ($interval->invert) { $hours_until_departure = 0; }

// The rule: The "Boarding Pass" layout is shown 48 hours before departure.
$is_boarding_time = ($hours_until_departure <= 48);
?>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        @page { margin: 0; }
        body { font-family: 'DejaVu Sans', sans-serif; font-size: 11px; color: #333; margin: 0; }
        .ticket { width: 100%; max-width: 800px; min-height: 300px; margin: 20px auto; border: 1px solid #ddd; display: table; table-layout: fixed; box-shadow: 0 0 10px rgba(0,0,0,0.1); border-radius: 10px; overflow: hidden; }
        .main { width: 70%; display: table-cell; padding: 0; vertical-align: top; }
        .stub { width: 30%; display: table-cell; vertical-align: top; border-left: 2px dashed #ccc; text-align: center; padding: 20px; background-color: #f9f9f9; }
        .header { background-color: <?php echo htmlspecialchars($site_settings['ticket_header_color'] ?? '#0d6efd'); ?>; color: white; padding: 10px 20px; display: table; width: 100%;}
        .header img { max-height: 35px; display: table-cell; vertical-align: middle; width: 40px; }
        .header h2 { display: table-cell; vertical-align: middle; font-size: 16px; padding-left: 15px; text-transform: uppercase; letter-spacing: 1px; }
        .content { padding: 20px; }
        .info-block h4 { color: <?php echo htmlspecialchars($site_settings['ticket_accent_color'] ?? '#888'); ?>; font-size: 10px; margin-bottom: 2px; text-transform: uppercase; letter-spacing: 0.5px; }
        .info-block p { font-size: 14px; font-weight: bold; margin: 0; }
        pre { font-family: 'DejaVu Sans', sans-serif; white-space: pre-wrap; margin: 0; }
        /* Boarding Pass Specific Styles */
        .boarding-pass .route-info .code { font-size: 42px; font-weight: bold; letter-spacing: 2px; }
        .boarding-pass .route-info .plane { font-size: 32px; vertical-align: middle; margin: 0 15px; color: <?php echo htmlspecialchars($site_settings['ticket_accent_color'] ?? '#888'); ?>; }
        .boarding-pass .itinerary { border: 1px solid #eee; padding: 10px; background-color: #fafafa; border-radius: 5px; font-size: 11px; margin-top: 15px; }
    </style>
</head>
<body>
    <?php if ($is_boarding_time): ?>
    <div class="ticket boarding-pass">
        <div class="main">
            <div class="header">
                <?php $logo_to_use = is_color_dark($site_settings['ticket_header_color']) ? $site_settings['site_logo_light_url'] : $site_settings['site_logo_url']; if (!empty($logo_to_use)): ?><img src="<?php echo $_SERVER['DOCUMENT_ROOT'] . '/' . strtok($logo_to_use, '?'); ?>"><?php endif; ?>
                <h2>Boarding Pass</h2>
            </div>
            <div class="content">
                <div class="route-info">
                    <span class="code"><?php echo htmlspecialchars($booking['origin_code']); ?></span>
                    <span class="plane">✈</span>
                    <span class="code"><?php echo htmlspecialchars($booking['dest_code']); ?></span>
                </div>
                <table style="width:100%; margin-bottom: 15px;"><tr>
                    <td style="width:65%; vertical-align: top;" class="info-block"><h4>PASSENGER NAME</h4><p><?php echo htmlspecialchars($booking['full_name']); ?></p></td>
                    <td style="width:35%; vertical-align: top;" class="info-block"><h4>DEPARTURE DATE</h4><p><?php echo date("d M Y", strtotime($booking['departure_date'])); ?></p></td>
                </tr></table>
                <div class="info-block itinerary"><pre><?php echo htmlspecialchars($booking['admin_notes']); ?></pre></div>
            </div>
        </div>
        <div class="stub">
            <p style="font-size: 12px; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['origin_city'] . ' → ' . $booking['dest_city']); ?></p>
            <h4>PASSENGER</h4><p style="font-size: 12px; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['full_name']); ?></p>
            <h4>BOOKING REF</h4><p style="font-size: 13px; font-weight: bold; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['booking_ref']); ?></p>
            <img src="<?php echo $qr_code_path; ?>" style="width: 100px; height: 100px;">
            <p style="font-size: 10px; color: #777; margin-top: 10px;">Scan to verify itinerary</p>
        </div>
    </div>
    <?php else: ?>
    <div class="ticket itinerary-receipt">
        <div class="main">
            <div class="header">
                <?php $logo_to_use = is_color_dark($site_settings['ticket_header_color']) ? $site_settings['site_logo_light_url'] : $site_settings['site_logo_url']; if (!empty($logo_to_use)): ?><img src="<?php echo $_SERVER['DOCUMENT_ROOT'] . '/' . strtok($logo_to_use, '?'); ?>"><?php endif; ?>
                <h2>Flight Itinerary Receipt</h2>
            </div>
            <div class="content">
                <div class="info-block" style="margin-bottom: 15px;"><h4>PASSENGER</h4><p><?php echo htmlspecialchars($booking['full_name']); ?></p></div>
                <table style="width:100%; margin-bottom: 15px;"><tr>
                    <td style="width:50%;" class="info-block"><h4>FROM</h4><p><?php echo htmlspecialchars($booking['origin_city']); ?></p></td>
                    <td style="width:50%;" class="info-block"><h4>TO</h4><p><?php echo htmlspecialchars($booking['dest_city']); ?></p></td>
                </tr></table>
                <div class="info-block itinerary"><pre><?php echo htmlspecialchars($booking['admin_notes']); ?></pre></div>
                 <p style="font-size: 10px; color: #777; margin-top: 20px;"><?php echo nl2br(htmlspecialchars($site_settings['ticket_notes_flight'] ?? '')); ?></p>
            </div>
        </div>
        <div class="stub">
            <p style="font-size: 12px; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['origin_city'] . ' → ' . $booking['dest_city']); ?></p>
            <h4>BOOKING REF</h4><p style="font-size: 13px; font-weight: bold; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['booking_ref']); ?></p>
            <img src="<?php echo $qr_code_path; ?>" style="width: 100px; height: 100px;">
            <p style="font-size: 10px; color: #777; margin-top: 10px;">Scan to verify</p>
            <p style="margin-top: 20px;"><strong style="color: green;">PAID IN FULL</strong><br><?php echo display_price($booking['total_price'], $current_currency, $rates, $site_settings['site_base_currency']); ?></p>
        </div>
    </div>
    <?php endif; ?>
</body>
</html>
