<?php
// 1. INCLUDE HEADER & HELPERS
include 'includes/header.php'; 
require_once 'includes/helpers.php'; 

// 2. VALIDATE SERVICE ID & FETCH DATA
$item_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$item_type = 'service'; // Set the type for this page
if (!$item_id) { /* Error handling */ exit(); }

$stmt_item = $conn->prepare("SELECT * FROM tours WHERE id = ? AND category = 'Service' AND status = 'published'");
$stmt_item->bind_param("i", $item_id);
$stmt_item->execute();
$item = $stmt_item->get_result()->fetch_assoc();
$stmt_item->close();
if (!$item) { /* Error handling */ exit(); }

// Check if this item is in the current user's wishlist
$is_in_wishlist = false;
if (isset($_SESSION['user_id'])) {
    $stmt_wish = $conn->prepare("SELECT id FROM wishlist_items WHERE user_id = ? AND item_id = ? AND item_type = ?");
    $stmt_wish->bind_param("iis", $_SESSION['user_id'], $item_id, $item_type); 
    $stmt_wish->execute();
    $is_in_wishlist = $stmt_wish->get_result()->num_rows > 0;
    $stmt_wish->close();
}
?>

<div class="container my-5">
    <div class="row g-5">
        <div class="col-lg-8">
             <h1 class="display-5 mb-3"><?php echo htmlspecialchars($item['title']); ?></h1>
            </div>
        <div class="col-lg-4">
             <div class="sticky-top" style="top: 20px;">
                <div class="card shadow-sm">
                    <div class="card-body">
                         <div class="d-grid gap-2">
                             <a href="#" class="btn btn-primary btn-lg">Book Now</a>
                             <button class="btn btn-outline-danger btn-lg d-flex align-items-center justify-content-center" id="wishlist-btn" 
                                     data-item-id="<?php echo $item_id; ?>" 
                                     data-item-type="<?php echo $item_type; ?>">
                                 <i class="bi <?php echo $is_in_wishlist ? 'bi-heart-fill' : 'bi-heart'; ?> me-2"></i>
                                 <span id="wishlist-text"><?php echo $is_in_wishlist ? 'Saved' : 'Save to Wishlist'; ?></span>
                             </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('wishlist-btn')?.addEventListener('click', function() { /* ... same script ... */ });
</script>

<?php include 'includes/footer.php'; ?>
