<?php 
require_once 'includes/header.php'; 

$booking_ref = trim($_GET['ref'] ?? '');
if (empty($booking_ref)) {
    die("<div class='container my-5'><div class='alert alert-danger'>No booking reference provided.</div></div>");
}

// Fetch booking details to display a summary
$stmt = $conn->prepare("SELECT b.*, t.title as tour_title FROM bookings b JOIN tours t ON b.tour_id = t.id WHERE b.booking_ref = ?");
$stmt->bind_param("s", $booking_ref);
$stmt->execute();
$booking = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$booking) {
    die("<div class='container my-5'><div class='alert alert-warning'>Booking not found.</div></div>");
}

$page_title = 'Payment Successful';
?>

<div class="container my-5">
    <div class="row justify-content-center">
        <div class="col-lg-8 text-center">
            <div class="card shadow-sm border-0">
                <div class="card-body p-5">
                    <i class="bi bi-patch-check-fill text-success" style="font-size: 5rem;"></i>
                    <h1 class="display-5 fw-bold mt-3">Payment Successful!</h1>
                    <p class="lead text-muted">Your booking is confirmed. A confirmation has been sent to your email.</p>
                    <hr class="my-4">
                    <h5 class="mb-3">Booking Summary</h5>
                    <p class="mb-1"><strong>Reference:</strong> <?php echo htmlspecialchars($booking['booking_ref']); ?></p>
                    <p class="mb-1"><strong>Tour:</strong> <?php echo htmlspecialchars($booking['tour_title']); ?></p>
                    <p class="mb-1"><strong>Total Paid:</strong> <?php echo format_price($booking['total_price']); ?></p>
                    <div class="d-grid gap-2 d-md-flex justify-content-md-center mt-4">
                        <a href="dashboard/my-bookings.php" class="btn btn-primary btn-lg">View My Bookings</a>
                        <a href="index.php" class="btn btn-outline-secondary btn-lg">Back to Homepage</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
require_once 'includes/footer.php'; 
?>
