<?php
include 'header.php'; 
require_once '../includes/image-resizer.php'; 
$message = '';
// --- CRUD LOGIC ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Update basic details
    if (isset($_POST['update_details'])) {
        $full_name = trim(strip_tags($_POST['full_name']));
        $phone_number = trim(strip_tags($_POST['phone_number']));
        $bio = trim(strip_tags($_POST['bio']));
        $payout_details = trim($_POST['payout_details']);
        $stmt = $conn->prepare("UPDATE users SET full_name = ?, phone_number = ?, bio = ?, payout_details = ? WHERE id = ?");
        $stmt->bind_param("ssssi", $full_name, $phone_number, $bio, $payout_details, $partner_id);
        if ($stmt->execute()) { $_SESSION['user_name'] = $full_name; $message .= '<div class="alert alert-success">Details updated.</div>'; }
    }
    // Change Password
    elseif (isset($_POST['change_password'])) { /* ... password change logic ... */ }
    // Profile Logo Upload
    elseif (isset($_POST['upload_logo'])) { /* ... logo upload logic ... */ }
    // Profile Page Request
    elseif (isset($_POST['request_profile_page'])) {
        $slug = strtolower(trim($_POST['profile_slug']));
        $slug = preg_replace('/[^a-z0-9-]+/', '', str_replace(' ', '-', $slug));
        $stmt_slug = $conn->prepare("SELECT id FROM users WHERE profile_slug = ? AND id != ?");
        $stmt_slug->bind_param("si", $slug, $partner_id); $stmt_slug->execute();
        if ($stmt_slug->get_result()->num_rows > 0) {
            $message .= '<div class="alert alert-danger">That custom URL is already taken.</div>';
        } else {
            $stmt_update = $conn->prepare("UPDATE users SET profile_slug = ?, profile_page_status = 'Requested', is_notified = 0 WHERE id = ?");
            $stmt_update->bind_param("si", $slug, $partner_id); $stmt_update->execute();
            $message .= '<div class="alert alert-success">Your request for a profile page has been submitted.</div>';
        }
    }
    // Re-fetch user data after any updates
    $user = $conn->query("SELECT * FROM users WHERE id = $partner_id")->fetch_assoc();
}
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom"><h1 class="h2">My Profile & Storefront</h1></div>
<?php echo $message; ?>
<div class="row">
    <div class="col-lg-8">
        <form method="POST">
            <div class="card shadow-sm mb-4"><div class="card-header">Business Details</div><div class="card-body">
                <div class="mb-3"><label>Business / Display Name</label><input type="text" name="full_name" class="form-control" value="<?php echo htmlspecialchars($user['full_name']); ?>" required></div>
                <div class="mb-3"><label>Bio (for public storefront page)</label><textarea name="bio" class="form-control" rows="4" placeholder="Tell customers about your business..."><?php echo htmlspecialchars($user['bio'] ?? ''); ?></textarea></div>
                <div class="mb-3"><label>Contact Phone</label><input type="text" name="phone_number" class="form-control" value="<?php echo htmlspecialchars($user['phone_number'] ?? ''); ?>"></div>
                <div class="mb-3"><label>Payout Details (e.g., GCash/Bank Info)</label><textarea name="payout_details" class="form-control" rows="4"><?php echo htmlspecialchars($user['payout_details'] ?? ''); ?></textarea></div>
                <button type="submit" name="update_details" class="btn btn-primary">Save Details</button>
            </div></div>
        </form>
    </div>
    <div class="col-lg-4">
        <div class="card shadow-sm"><div class="card-header fw-bold">My Public Storefront</div><div class="card-body">
            <?php if ($user['is_verified'] == 0): ?><div class="alert alert-warning">You must be a Verified Partner to request a storefront.</div>
            <?php elseif ($user['profile_page_status'] == 'Active'): ?>
                <p>Your storefront page is live!</p>
                <a href="/partner/<?php echo htmlspecialchars($user['profile_slug']); ?>" target="_blank" class="btn btn-success"><i class="bi bi-eye-fill"></i> View My Storefront</a>
            <?php elseif ($user['profile_page_status'] == 'Requested'): ?><div class="alert alert-info">Your request is pending admin approval.</div>
            <?php else: ?>
                <p>Request a public page to showcase your listings.</p>
                <form method="POST"><label class="form-label">Choose Your URL:</label><div class="input-group mb-2"><span class="input-group-text">.../partner/</span><input type="text" name="profile_slug" class="form-control" required></div><button type="submit" name="request_profile_page" class="btn btn-primary">Submit Request</button></form>
            <?php endif; ?>
        </div></div>
    </div>
</div>
<?php include 'footer.php'; ?>
