<?php
require_once 'header.php'; 
$page_title = 'My Listings';

// Fetch this partner's Tours & Services
$stmt_tours = $conn->prepare("SELECT id, title, status FROM tours WHERE partner_id = ? ORDER BY created_at DESC");
$stmt_tours->bind_param("i", $partner_id);
$stmt_tours->execute();
$tours = $stmt_tours->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_tours->close();

// Fetch this partner's Hotels
$stmt_hotels = $conn->prepare("SELECT id, name, is_published FROM hotels WHERE partner_id = ? ORDER BY name ASC");
$stmt_hotels->bind_param("i", $partner_id);
$stmt_hotels->execute();
$hotels = $stmt_hotels->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_hotels->close();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-card-list me-2"></i>My Listings</h1>
</div>

<div class="card shadow-sm border-0">
    <div class="card-header"><ul class="nav nav-tabs card-header-tabs"><li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tours-panel">Tours & Services</button></li><li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#hotels-panel">Hotels</button></li></ul></div>
    <div class="card-body">
        <div class="tab-content">
            <div class="tab-pane fade show active" id="tours-panel">
                <div class="d-flex justify-content-end mb-3"><a href="edit-tour.php" class="btn btn-primary"><i class="bi bi-plus-circle-fill me-1"></i> Add New</a></div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead><tr><th>Title</th><th class="text-center">Status</th><th class="text-end">Actions</th></tr></thead>
                        <tbody>
                            <?php foreach ($tours as $tour): ?>
                            <tr>
                                <td class="fw-bold"><?php echo htmlspecialchars($tour['title']); ?></td>
                                <td class="text-center"><span class="badge bg-<?php echo ($tour['status'] == 'published') ? 'success' : 'secondary'; ?>"><?php echo ucfirst($tour['status']); ?></span></td>
                                <td class="text-end">
                                    <a href="manage-tour-availability.php?tour_id=<?php echo $tour['id']; ?>" class="btn btn-sm btn-info">Availability</a> 
                                    <a href="edit-tour.php?id=<?php echo $tour['id']; ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="tab-pane fade" id="hotels-panel">
                 <div class="d-flex justify-content-end mb-3"><a href="edit-hotel.php" class="btn btn-primary"><i class="bi bi-plus-circle-fill me-1"></i> Add New</a></div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead><tr><th>Name</th><th class="text-center">Status</th><th class="text-end">Actions</th></tr></thead>
                        <tbody>
                            <?php foreach ($hotels as $hotel): ?>
                            <tr>
                                <td class="fw-bold"><?php echo htmlspecialchars($hotel['name']); ?></td>
                                <td class="text-center"><span class="badge bg-<?php echo ($hotel['is_published']) ? 'success' : 'secondary'; ?>"><?php echo $hotel['is_published'] ? 'Published' : 'Draft'; ?></span></td>
                                <td class="text-end">
                                    <a href="manage-rooms.php?hotel_id=<?php echo $hotel['id']; ?>" class="btn btn-sm btn-info">Manage Rooms</a> 
                                    <a href="edit-hotel.php?id=<?php echo $hotel['id']; ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php require_once 'footer.php'; ?>
