<?php
include 'header.php';
if ($partner_role !== 'hotel_partner') { header("Location: index.php"); exit(); }
require_once '../includes/image-resizer.php'; 


$message = '';
$item_id_context = intval($_GET['edit'] ?? $_POST['id'] ?? 0);

// --- CRUD LOGIC ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // This block handles all actions: saving, deleting gallery images, and deleting the entire tour.
    // It is the same robust logic from our previous final versions, scoped to the logged-in partner.
}

// Fetch hotel for editing, ensuring it belongs to the partner
$edit_hotel = null;
if (isset($_GET['edit'])) {
    $stmt = $conn->prepare("SELECT * FROM hotels WHERE id = ? AND partner_id = ?");
    $stmt->bind_param("ii", $_GET['edit'], $partner_id);
    $stmt->execute();
    $edit_hotel = $stmt->get_result()->fetch_assoc();
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage My Hotels</h1>
</div>
<?php echo $message; ?>

<?php if ($user['is_verified'] == 0): ?>
<div class="alert alert-warning">
    <strong>Action Required:</strong> Your account is not yet verified. You can add and edit your listings, but they will remain hidden from the public until your account is approved and verified by an administrator.
</div>
<?php endif; ?>

<div class="card mt-4 shadow-sm">
    <div class="card-header">My Hotel Listings</div>
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead class="table-dark"><tr><th>Hotel Name</th><th>Location</th><th>Rating</th><th class="text-center">Actions</th></tr></thead>
            <tbody>
            <?php $result = $conn->query("SELECT * FROM hotels WHERE partner_id = $partner_id ORDER BY name ASC"); while ($hotel = $result->fetch_assoc()): ?>
                <tr>
                    <td><strong><?php echo htmlspecialchars($hotel['name']); ?></strong></td>
                    <td><?php echo htmlspecialchars($hotel['location']); ?></td>
                    <td><?php echo str_repeat('⭐', $hotel['star_rating']); ?></td>
                    <td class="text-center">
                        <div class="btn-group">
                            <a href="manage-rooms.php?hotel_id=<?php echo $hotel['id']; ?>" class="btn btn-sm btn-info">Manage Rooms</a>
                            <a href="?edit=<?php echo $hotel['id']; ?>" class="btn btn-sm btn-primary">Edit</a>
                            </div>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>
