<?php
require_once 'header.php';
$room_id = filter_input(INPUT_GET, 'room_id', FILTER_VALIDATE_INT);
if (!$room_id) { die("Invalid Room ID."); }

$stmt = $conn->prepare("SELECT r.room_type_name, h.name AS hotel_name, h.id AS hotel_id FROM hotel_rooms r JOIN hotels h ON r.hotel_id = h.id WHERE r.id = ? AND h.partner_id = ?");
$stmt->bind_param("ii", $room_id, $partner_id);
$stmt->execute();
$room_details = $stmt->get_result()->fetch_assoc();
$stmt->close();
if (!$room_details) { die("Error: Room not found or you do not have permission to manage it."); }

$page_title = 'Availability: ' . htmlspecialchars($room_details['room_type_name']);
$month = isset($_GET['month']) ? (int)$_GET['month'] : date('m');
$year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'bulk_update') {
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $rooms = filter_input(INPUT_POST, 'rooms_available', FILTER_VALIDATE_INT);
    $price = filter_input(INPUT_POST, 'price', FILTER_VALIDATE_FLOAT, FILTER_NULL_ON_FAILURE);

    if ($start_date && $end_date && $rooms >= 0) {
        $current = new DateTime($start_date);
        $end = new DateTime($end_date);
        $sql = "INSERT INTO hotel_room_availability (room_id, available_date, rooms_available, price) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE rooms_available = VALUES(rooms_available), price = VALUES(price)";
        $stmt_update = $conn->prepare($sql);
        while ($current <= $end) {
            $stmt_update->bind_param("isid", $room_id, $current->format('Y-m-d'), $rooms, $price);
            $stmt_update->execute();
            $current->modify('+1 day');
        }
        $stmt_update->close();
    }
    header("Location: " . $_SERVER['REQUEST_URI']);
    exit();
}

$first_day = new DateTime("$year-$month-01");
$first_day_of_month_str = $first_day->format('Y-m-d');
$last_day_of_month_str = $first_day->format('Y-m-t');
$stmt_cal = $conn->prepare("SELECT available_date, rooms_available, price FROM hotel_room_availability WHERE room_id = ? AND available_date BETWEEN ? AND ?");
$stmt_cal->bind_param("iss", $room_id, $first_day_of_month_str, $last_day_of_month_str);
$stmt_cal->execute();
$availability_data = $stmt_cal->get_result()->fetchAll(PDO::FETCH_KEY_PAIR | PDO::FETCH_GROUP);
$stmt_cal->close();
?>
<div class="d-flex justify-content-between align-items-center pt-3 pb-2 mb-3 border-bottom">
    <div><h1 class="h2">Manage Room Availability</h1><p class="text-muted"><?php echo htmlspecialchars($room_details['room_type_name']); ?> at <?php echo htmlspecialchars($room_details['hotel_name']); ?></p></div>
    <a href="manage-rooms.php?hotel_id=<?php echo $room_details['hotel_id']; ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back to Rooms</a>
</div>
<div class="card shadow-sm border-0 mb-4"><div class="card-header bg-light border-0"><h5 class="mb-0">Bulk Update Tool</h5></div><div class="card-body"><form method="POST"><input type="hidden" name="action" value="bulk_update"><div class="row g-3 align-items-end"><div class="col-md-3"><label class="form-label">Start</label><input type="date" name="start_date" class="form-control" required></div><div class="col-md-3"><label class="form-label">End</label><input type="date" name="end_date" class="form-control" required></div><div class="col-md-2"><label class="form-label"># Rooms</label><input type="number" name="rooms_available" class="form-control" min="0" required></div><div class="col-md-2"><label class="form-label">Price</label><input type="text" name="price" class="form-control"></div><div class="col-md-2"><button type="submit" class="btn btn-primary w-100">Apply</button></div></div></form></div></div>
<div class="card shadow-sm border-0"><div class="card-header bg-light border-0 d-flex justify-content-between align-items-center"><h5 class="mb-0"><?php echo $first_day->format('F Y'); ?></h5></div><div class="card-body"></div></div>
<script></script>
<?php require_once 'footer.php'; ?>
