<?php
require_once 'header.php'; 
$page_title = 'Partner Dashboard';

// --- QUERIES FOR DASHBOARD WIDGETS ---
$partner_id = $_SESSION['user_id'];

// Total earnings (This will require an `earnings` table)
$total_earnings = 0; // Placeholder

// Total bookings on their listings
$stmt = $conn->prepare("SELECT COUNT(b.id) as total FROM bookings b JOIN tours t ON b.tour_id = t.id WHERE t.partner_id = ?");
$stmt->bind_param("i", $partner_id);
$stmt->execute();
$total_bookings = $stmt->get_result()->fetch_assoc()['total'];
$stmt->close();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Dashboard</h1>
</div>

<div class="row">
    <div class="col-md-6 mb-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <h5 class="card-title text-success">Total Earnings</h5>
                <p class="card-text fs-2 fw-bold"><?php echo format_price($total_earnings); ?></p>
            </div>
        </div>
    </div>
    <div class="col-md-6 mb-3">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <h5 class="card-title text-primary">Total Bookings</h5>
                <p class="card-text fs-2 fw-bold"><?php echo $total_bookings; ?></p>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0 mt-4">
    <div class="card-header bg-light border-0"><h5>Recent Activity</h5></div>
    <div class="card-body text-center text-muted">
        <p>Recent booking activity on your listings will appear here.</p>
    </div>
</div>

<?php require_once 'footer.php'; ?>
