<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_role']) || !str_contains($_SESSION['user_role'], 'partner')) {
    header("Location: ../login.php");
    exit();
}

require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';

$partner_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $partner_id);
$stmt->execute();
$partner_user = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$partner_user) {
    session_destroy();
    header("Location: ../login.php?error=invalid_session");
    exit();
}
$current_page = basename($_SERVER['SCRIPT_NAME']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) : 'Partner Dashboard'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="../css/style.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark sticky-top shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand" href="../index.php">Partner Portal</a>
    <div class="dropdown ms-auto">
        <a href="#" class="d-flex align-items-center text-white text-decoration-none dropdown-toggle" data-bs-toggle="dropdown">
            <strong><?php echo htmlspecialchars($partner_user['full_name']); ?></strong>
        </a>
        <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end shadow">
            <li><a class="dropdown-item" href="edit-profile.php"><i class="bi bi-person-fill-gear me-2"></i> Edit Profile</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="../logout.php"><i class="bi bi-box-arrow-right me-2"></i> Log Out</a></li>
        </ul>
    </div>
  </div>
</nav>
<div class="container-fluid">
    <div class="row">
        <nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse vh-100 border-end">
            <div class="pt-3">
                <ul class="nav flex-column">
                    <li class="nav-item"><a class="nav-link <?php if($current_page == 'index.php') echo 'active'; ?>" href="index.php"><i class="bi bi-grid-1x2-fill me-2"></i> Dashboard</a></li>
                    <li class="nav-item"><a class="nav-link <?php if($current_page == 'my-bookings.php') echo 'active'; ?>" href="my-bookings.php"><i class="bi bi-briefcase-fill me-2"></i> Bookings</a></li>
                    <li class="nav-item"><a class="nav-link <?php if($current_page == 'manage-listings.php') echo 'active'; ?>" href="manage-listings.php"><i class="bi bi-card-list me-2"></i> My Listings</a></li>
                    <li class="nav-item"><a class="nav-link <?php if($current_page == 'earnings.php') echo 'active'; ?>" href="earnings.php"><i class="bi bi-cash-coin me-2"></i> Earnings</a></li>
                    <li class="nav-item"><a class="nav-link <?php if($current_page == 'submit-documents.php') echo 'active'; ?>" href="submit-documents.php"><i class="bi bi-file-earmark-check me-2"></i> Documents</a></li>
                </ul>
            </div>
        </nav>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 bg-light">
