<?php
require_once 'header.php';

// --- Determine if we are editing an existing tour or creating a new one ---
$edit_mode = false;
$tour_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$tour = ['title' => '', 'category' => 'Tour', 'location' => '', 'price' => '', 'description' => '']; // Default values

if ($tour_id) {
    // SECURITY: Fetch the tour AND verify it belongs to the logged-in partner
    $stmt = $conn->prepare("SELECT * FROM tours WHERE id = ? AND partner_id = ?");
    $stmt->bind_param("ii", $tour_id, $partner_id);
    $stmt->execute();
    $tour = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    if ($tour) { $edit_mode = true; } 
    else { die('Error: Tour not found or you do not have permission to edit it.'); }
}
$page_title = $edit_mode ? 'Edit Listing' : 'Add New Listing';


// --- Handle Form Submission ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get form data
    $title = trim($_POST['title']);
    $category = $_POST['category'];
    $location = trim($_POST['location']);
    $price = $_POST['price'];
    $description = trim($_POST['description']);
    // (Add file upload logic for image_url here)

    if ($edit_mode) {
        $stmt = $conn->prepare("UPDATE tours SET title = ?, category = ?, location = ?, price = ?, description = ? WHERE id = ? AND partner_id = ?");
        $stmt->bind_param("sssdsii", $title, $category, $location, $price, $description, $tour_id, $partner_id);
    } else {
        $stmt = $conn->prepare("INSERT INTO tours (partner_id, title, category, location, price, description, status) VALUES (?, ?, ?, ?, ?, ?, 'draft')");
        $stmt->bind_param("isssds", $partner_id, $title, $category, $location, $price, $description);
    }
    $stmt->execute();
    $stmt->close();
    
    header("Location: manage-listings.php");
    exit();
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-pencil-square me-2"></i><?php echo $page_title; ?></h1>
    <a href="manage-listings.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back to Listings</a>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <form method="POST" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-8 mb-3"><label for="title" class="form-label">Listing Title</label><input type="text" class="form-control" name="title" value="<?php echo htmlspecialchars($tour['title']); ?>" required></div>
                <div class="col-md-4 mb-3"><label for="category" class="form-label">Category</label><select class="form-select" name="category" required><option value="Tour" <?php if($tour['category'] == 'Tour') echo 'selected'; ?>>Tour</option><option value="Service" <?php if($tour['category'] == 'Service') echo 'selected'; ?>>Service</option></select></div>
            </div>
            <div class="row">
                <div class="col-md-8 mb-3"><label for="location" class="form-label">Location / Area</label><input type="text" class="form-control" name="location" value="<?php echo htmlspecialchars($tour['location']); ?>" required></div>
                <div class="col-md-4 mb-3"><label for="price" class="form-label">Price (per person)</label><input type="number" step="0.01" class="form-control" name="price" value="<?php echo htmlspecialchars($tour['price']); ?>" required></div>
            </div>
            <div class="mb-3"><label for="description" class="form-label">Description</label><textarea class="form-control" name="description" rows="8" required><?php echo htmlspecialchars($tour['description']); ?></textarea></div>
            <button type="submit" class="btn btn-primary">Save Listing</button>
        </form>
    </div>
</div>

<?php require_once 'footer.php'; ?>
