<?php
require_once 'includes/init.php';

if (isset($_SESSION['user_id'])) {
    if ($_SESSION['user_role'] === 'admin') { header("Location: admin/"); }
    elseif (str_contains($_SESSION['user_role'], 'partner')) { header("Location: partner/"); }
    else { header("Location: dashboard/"); }
    exit();
}

$error_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        $error_message = "Please enter both email and password.";
    } else {
        $stmt = $conn->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        if ($user && password_verify($password, $user['password'])) {
            if ($user['status'] === 'active') {
                session_regenerate_id(true);
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_role'] = $user['role'];
                $_SESSION['user_name'] = $user['full_name'];
                
                if (str_contains($user['role'], 'partner')) {
                    $redirect_url = 'partner/';
                } elseif ($user['role'] === 'admin') {
                    $redirect_url = 'admin/';
                } else {
                    $redirect_url = 'dashboard/';
                }
                
                header("Location: " . $redirect_url);
                exit();
            } else { $error_message = "Your account is inactive or suspended."; }
        } else { $error_message = "Invalid email or password."; }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login to Your Account</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="container"><div class="row justify-content-center align-items-center vh-100"><div class="col-md-8 col-lg-6 col-xl-5"><div class="text-center mb-4"><h1 class="h2">Sign In</h1></div><div class="card shadow-sm border-0"><div class="card-body p-4 p-md-5"><?php if (!empty($error_message)): ?><div class="alert alert-danger"><?php echo $error_message; ?></div><?php endif; ?><form method="POST"><div class="mb-3"><label for="email" class="form-label">Email address</label><input type="email" class="form-control" id="email" name="email" required></div><div class="mb-3"><label for="password" class="form-label">Password</label><input type="password" class="form-control" id="password" name="password" required></div><div class="d-flex justify-content-between align-items-center mb-4"><div class="form-check"><input class="form-check-input" type="checkbox" name="remember_me" id="remember_me"><label class="form-check-label" for="remember_me">Remember me</label></div><a href="forgot-password.php" class="small">Forgot password?</a></div><div class="d-grid mb-3"><button type="submit" class="btn btn-primary btn-lg">Sign In</button></div></form></div></div><div class="text-center mt-4"><p class="text-muted">Don't have an account? <a href="register.php">Sign Up</a></p></div></div></div></div>
</body>
</html>
