import type { FormatDateString } from '@src/index';

const getDateString: (date: Date) => FormatDateString = (date: Date) => {
  const year = date.getFullYear();
  const month = String(date.getMonth() + 1).padStart(2, '0');
  const day = String(date.getDate()).padStart(2, '0');

  return `${year}-${month}-${day}` as FormatDateString;
};

export default getDateString;
