<?php 
$page_title = 'Your Ultimate Travel Hub';
require_once 'includes/header.php'; 

// --- ALL PAGE-SPECIFIC QUERIES ---
$airports_result = $conn->query("SELECT id, airport_name, airport_code FROM airports ORDER BY airport_name ASC");
$airports = $airports_result->fetch_all(MYSQLI_ASSOC);
$ferry_ports_result = $conn->query("SELECT id, name FROM ferry_ports ORDER BY name ASC");
$ferry_ports = $ferry_ports_result->fetch_all(MYSQLI_ASSOC);
$stmt_dest = $conn->prepare("SELECT name, short_description, hero_image_url FROM destinations WHERE is_featured = 1 LIMIT 4");
$stmt_dest->execute();
$destinations = $stmt_dest->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_dest->close();
$stmt_tours = $conn->prepare("SELECT id, title, location, price, image_url FROM tours WHERE status = 'published' AND is_featured = 1 AND category = 'Tour' LIMIT 4");
$stmt_tours->execute();
$recommended_tours = $stmt_tours->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_tours->close();
$stmt_hotels = $conn->prepare("SELECT id, name, location, main_image_url, star_rating FROM hotels WHERE is_published = 1 AND is_recommended = 1 LIMIT 4");
$stmt_hotels->execute();
$featured_hotels = $stmt_hotels->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_hotels->close();
$stmt_services = $conn->prepare("SELECT id, title, location, price, image_url FROM tours WHERE status = 'published' AND is_featured = 1 AND category = 'Service' LIMIT 4");
$stmt_services->execute();
$featured_services = $stmt_services->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_services->close();
$stmt_reviews = $conn->prepare("SELECT ur.rating, ur.review_text, u.full_name, u.profile_image_url FROM user_reviews ur JOIN users u ON ur.user_id = u.id WHERE ur.is_approved = 1 AND ur.rating >= 4 ORDER BY ur.created_at DESC LIMIT 5");
$stmt_reviews->execute();
$reviews = $stmt_reviews->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_reviews->close();
$stmt_articles = $conn->prepare("SELECT id, title, excerpt, image_url, publish_date FROM articles WHERE status = 'published' ORDER BY publish_date DESC LIMIT 3");
$stmt_articles->execute();
$latest_articles = $stmt_articles->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_articles->close();
$affiliations_result = $conn->query("SELECT name, logo_url FROM affiliations ORDER BY id ASC");
$affiliations = $affiliations_result->fetch_all(MYSQLI_ASSOC);
?>

<section class="hero-section text-white text-center" style="background-image: url('<?php echo htmlspecialchars($site_settings['banner_image_url'] ?? 'assets/images/default-banner.jpg'); ?>');">
    <div class="container">
        <h1 class="display-4 fw-bold"><?php echo htmlspecialchars($site_settings['banner_heading'] ?? 'Your Adventure Awaits'); ?></h1>
        <p class="lead mb-5"><?php echo htmlspecialchars($site_settings['banner_subheading'] ?? 'Discover the best destinations with us.'); ?></p>
        <div class="card shadow-lg" style="background-color: rgba(0,0,0,0.2); backdrop-filter: blur(10px);">
            <div class="card-header bg-transparent border-0 pt-3"><ul class="nav nav-tabs card-header-tabs" id="bookingTabs" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#flights-panel" type="button"><i class="bi bi-airplane me-1"></i> Flights</button></li><li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#hotels-panel" type="button"><i class="bi bi-building me-1"></i> Hotels</button></li><li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tours-panel" type="button"><i class="bi bi-compass-fill me-1"></i> Tours</button></li><li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#ferries-panel" type="button"><i class="bi bi-tsunami me-1"></i> Ferries</button></li><li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#services-panel" type="button"><i class="bi bi-briefcase-fill me-1"></i> Services</button></li></ul></div>
            <div class="card-body p-4"><div class="tab-content text-start" id="bookingTabsContent"><div class="tab-pane fade show active" id="flights-panel" role="tabpanel"><form action="flights.php" method="GET"><div class="form-check form-check-inline mb-2"><input class="form-check-input" type="radio" name="trip_type" id="flight-roundtrip" value="roundtrip" checked><label class="form-check-label text-white" for="flight-roundtrip">Round-trip</label></div><div class="form-check form-check-inline mb-2"><input class="form-check-input" type="radio" name="trip_type" id="flight-oneway" value="oneway"><label class="form-check-label text-white" for="flight-oneway">One-way</label></div><div class="row g-3 align-items-end"><div class="col-lg"><label class="form-label text-white">From</label><select name="origin_id" class="form-select form-select-lg"><option selected disabled>Origin</option><?php foreach($airports as $airport): ?><option value="<?php echo $airport['id']; ?>"><?php echo htmlspecialchars($airport['airport_name'] . ' (' . $airport['airport_code'] . ')'); ?></option><?php endforeach; ?></select></div><div class="col-lg-auto align-self-center"><button type="button" class="btn btn-link icon-swap text-white" onclick="swapValues('flights-panel')"><i class="bi bi-arrow-left-right"></i></button></div><div class="col-lg"><label class="form-label text-white">To</label><select name="destination_id" class="form-select form-select-lg"><option selected disabled>Destination</option><?php foreach($airports as $airport): ?><option value="<?php echo $airport['id']; ?>"><?php echo htmlspecialchars($airport['airport_name'] . ' (' . $airport['airport_code'] . ')'); ?></option><?php endforeach; ?></select></div><div class="col-lg-2"><label class="form-label text-white">Depart</label><input type="date" name="departure_date" class="form-control form-control-lg"></div><div class="col-lg-2"><label class="form-label text-white">Return</label><input type="date" name="return_date" class="form-control form-control-lg"></div><div class="col-lg-auto"><button type="submit" class="btn btn-primary btn-lg w-100">Search</button></div></div></form></div><div class="tab-pane fade" id="hotels-panel" role="tabpanel"><form action="hotels.php" method="GET" class="row g-3 align-items-end"><div class="col-lg"><label class="form-label text-white">Destination</label><input type="text" name="location" class="form-control form-control-lg" placeholder="e.g., Boracay"></div><div class="col-lg-2"><label class="form-label text-white">Check-in</label><input type="date" name="check_in_date" class="form-control form-control-lg"></div><div class="col-lg-2"><label class="form-label text-white">Check-out</label><input type="date" name="check_out_date" class="form-control form-control-lg"></div><div class="col-lg-auto"><button type="submit" class="btn btn-primary btn-lg w-100">Search</button></div></form></div><div class="tab-pane fade" id="tours-panel" role="tabpanel"><form action="tours.php" method="GET" class="row g-3 align-items-end"><div class="col-lg"><label class="form-label text-white">Destination or Tour</label><input type="text" name="query" class="form-control form-control-lg" placeholder="e.g., El Nido"></div><div class="col-lg-auto"><button type="submit" class="btn btn-primary btn-lg w-100">Search</button></div></form></div><div class="tab-pane fade" id="ferries-panel" role="tabpanel"><form action="ferries.php" method="GET" class="row g-3 align-items-end"><div class="col-lg"><label class="form-label text-white">From</label><select name="origin_port_id" class="form-select form-select-lg"><option selected disabled>Origin Port</option><?php foreach($ferry_ports as $port): ?><option value="<?php echo $port['id']; ?>"><?php echo htmlspecialchars($port['name']); ?></option><?php endforeach; ?></select></div><div class="col-lg-auto align-self-center"><button type="button" class="btn btn-link icon-swap text-white" onclick="swapValues('ferries-panel')"><i class="bi bi-arrow-left-right"></i></button></div><div class="col-lg"><label class="form-label text-white">To</label><select name="destination_port_id" class="form-select form-select-lg"><option selected disabled>Destination Port</option><?php foreach($ferry_ports as $port): ?><option value="<?php echo $port['id']; ?>"><?php echo htmlspecialchars($port['name']); ?></option><?php endforeach; ?></select></div><div class="col-lg-3"><label class="form-label text-white">Depart</label><input type="date" name="departure_date" class="form-control form-control-lg"></div><div class="col-lg-auto"><button type="submit" class="btn btn-primary btn-lg w-100">Search</button></div></form></div><div class="tab-pane fade" id="services-panel" role="tabpanel"><form action="services.php" method="GET" class="row g-3 align-items-end"><div class="col-lg"><label class="form-label text-white">Service</label><input type="text" class="form-control form-control-lg" placeholder="e.g., Airport Transfer"></div><div class="col-lg-auto"><button type="submit" class="btn btn-primary btn-lg w-100">Search</button></div></form></div></div></div>
        </div>
    </div>
</section>

<section class="py-5"><div class="container"><div class="text-center mb-5"><h2 class="fw-bold">Popular Destinations</h2></div><div class="row"><?php foreach ($destinations as $dest): ?><div class="col-lg-3 col-md-6 mb-4"><a href="#" class="text-decoration-none"><div class="card text-white feature-card"><img src="<?php echo htmlspecialchars($dest['hero_image_url']); ?>" class="card-img" alt="<?php echo htmlspecialchars($dest['name']); ?>" style="height: 350px; object-fit: cover;"><div class="card-img-overlay d-flex flex-column justify-content-end" style="background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);"><h4 class="card-title"><?php echo htmlspecialchars($dest['name']); ?></h4></div></div></a></div><?php endforeach; ?></div></div></section>

<section class="py-5 bg-light"><div class="container"><div class="text-center mb-5"><h2 class="fw-bold">Recommended Tours</h2></div><div class="row"><?php foreach ($recommended_tours as $tour): ?><div class="col-lg-3 col-md-6 mb-4"><div class="card feature-card"><img src="<?php echo htmlspecialchars($tour['image_url']); ?>" class="card-img-top"><div class="card-body d-flex flex-column"><h5 class="card-title"><?php echo htmlspecialchars($tour['title']); ?></h5><p class="card-text small text-muted flex-grow-1"><i class="bi bi-geo-alt-fill me-1"></i><?php echo htmlspecialchars($tour['location']); ?></p><a href="tour-details.php?id=<?php echo $tour['id']; ?>" class="btn btn-sm btn-outline-primary mt-auto">View Details</a></div></div></div><?php endforeach; ?></div><div class="text-center mt-4"><a href="tours.php" class="btn btn-outline-primary">View All Tours</a></div></div></section>

<section class="py-5"><div class="container"><div class="text-center mb-5"><h2 class="fw-bold">Our Top Hotels</h2></div><div class="row"><?php foreach ($featured_hotels as $hotel): ?><div class="col-lg-3 col-md-6 mb-4"><div class="card feature-card"><img src="<?php echo htmlspecialchars($hotel['main_image_url']); ?>" class="card-img-top"><div class="card-body d-flex flex-column"><h5 class="card-title"><?php echo htmlspecialchars($hotel['name']); ?></h5><div class="mb-2"><?php for($i=0; $i<$hotel['star_rating']; $i++) echo '<i class="bi bi-star-fill text-warning"></i>'; ?></div><p class="card-text small text-muted flex-grow-1"><i class="bi bi-geo-alt-fill me-1"></i><?php echo htmlspecialchars($hotel['location']); ?></p><a href="hotel-details.php?id=<?php echo $hotel['id']; ?>" class="btn btn-sm btn-outline-primary mt-auto">View Hotel</a></div></div></div><?php endforeach; ?></div><div class="text-center mt-4"><a href="hotels.php" class="btn btn-outline-primary">View All Hotels</a></div></div></section>

<section class="py-5 bg-light"><div class="container"><div class="text-center mb-5"><h2 class="fw-bold">What Our Travelers Say</h2></div><div id="reviewsCarousel" class="carousel slide" data-bs-ride="carousel"><div class="carousel-inner"><?php if(!empty($reviews)): foreach ($reviews as $index => $review): ?><div class="carousel-item <?php echo $index === 0 ? 'active' : ''; ?>"><div class="d-flex flex-column align-items-center text-center p-md-5"><?php if (!empty($review['profile_image_url'])): ?><img src="<?php echo htmlspecialchars($review['profile_image_url']); ?>" class="rounded-circle mb-3" width="80" height="80" style="object-fit: cover;" alt="Reviewer"><?php endif; ?><p class="lead fst-italic mx-md-5">"<?php echo htmlspecialchars($review['review_text']); ?>"</p><div class="mt-3"><strong class="d-block"><?php echo htmlspecialchars($review['full_name']); ?></strong><div class="text-warning"><?php for($i = 0; $i < $review['rating']; $i++) echo '<i class="bi bi-star-fill"></i>'; ?></div></div></div></div><?php endforeach; endif; ?></div></div></div></section>

<section class="py-5"><div class="container"><div class="text-center mb-5"><h2 class="fw-bold">Why Book With Us?</h2></div><div class="row text-center"><div class="col-md-4 mb-4"><div class="p-4"><i class="bi bi-patch-check-fill fs-1 text-primary mb-3"></i><h5 class="fw-bold">Verified Partners</h5><p class="text-muted">We work with trusted operators.</p></div></div><div class="col-md-4 mb-4"><div class="p-4"><i class="bi bi-headset fs-1 text-primary mb-3"></i><h5 class="fw-bold">24/7 Support</h5><p class="text-muted">Our support team is here to help.</p></div></div><div class="col-md-4 mb-4"><div class="p-4"><i class="bi bi-wallet2 fs-1 text-primary mb-3"></i><h5 class="fw-bold">Best Price Guarantee</h5><p class="text-muted">Transparent pricing with no hidden fees.</p></div></div></div></div></section>

<section class="py-5 bg-light"><div class="container"><div class="text-center mb-5"><h2 class="fw-bold">From Our Blog</h2></div><div class="row"><?php foreach ($latest_articles as $article): ?><div class="col-md-4 mb-4"><div class="card feature-card"><img src="<?php echo htmlspecialchars($article['image_url']); ?>" class="card-img-top"><div class="card-body"><p class="small text-muted"><?php echo date('F j, Y', strtotime($article['publish_date'])); ?></p><h5 class="card-title"><?php echo htmlspecialchars($article['title']); ?></h5><a href="article-details.php?id=<?php echo $article['id']; ?>">Read More &rarr;</a></div></div></div><?php endforeach; ?></div><div class="text-center mt-4"><a href="articles.php" class="btn btn-outline-primary">Read More From Our Blog</a></div></div></section>

<?php 
require_once 'includes/footer.php'; 
?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const flightTripTypeRadios = document.querySelectorAll('#flights-panel input[name="trip_type"]');
    const flightReturnDateInput = document.querySelector('#flights-panel input[name="return_date"]');
    flightTripTypeRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            flightReturnDateInput.disabled = this.value === 'oneway';
        });
    });
    window.swapValues = function(panelId) {
        const panel = document.getElementById(panelId);
        const originSelect = panel.querySelector('select[name^="origin"]');
        const destSelect = panel.querySelector('select[name^="destination"]');
        const originVal = originSelect.value;
        originSelect.value = destSelect.value;
        destSelect.value = originVal;
    }
});
</script>
