<?php
// This is the finalized header for your public-facing website.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php'; 

// --- Fetch All Global Site Settings in One Query ---
$site_settings = [];
if ($conn) {
    $settings_keys = ['site_name', 'site_logo_url', 'favicon_url', 'seo_meta_title', 'seo_meta_description', 'seo_meta_keywords', 'notification_banner_text', 'notification_banner_status', 'site_base_currency', 'header_contact_phone', 'header_contact_email'];
    $placeholders = implode(',', array_fill(0, count($settings_keys), '?'));
    
    $stmt = $conn->prepare("SELECT setting_name, setting_value FROM site_settings WHERE setting_name IN ($placeholders)");
    $stmt->bind_param(str_repeat('s', count($settings_keys)), ...$settings_keys);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $site_settings[$row['setting_name']] = $row['setting_value'];
    }
    $stmt->close();
}
$current_page = basename($_SERVER['SCRIPT_NAME']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title ?? $site_settings['seo_meta_title'] ?? 'Welcome!'); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($site_settings['seo_meta_description'] ?? ''); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($site_settings['seo_meta_keywords'] ?? ''); ?>">
    <link rel="icon" type="image/x-icon" href="<?php echo htmlspecialchars($site_settings['favicon_url'] ?? '/favicon.ico'); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<div class="bg-dark text-white-50 py-2 small">
    <div class="container d-flex justify-content-between">
        <div>
            <?php if (!empty($site_settings['header_contact_phone'])): ?><a href="tel:<?php echo htmlspecialchars($site_settings['header_contact_phone']); ?>" class="text-white me-3"><i class="bi bi-telephone-fill me-1"></i> <?php echo htmlspecialchars($site_settings['header_contact_phone']); ?></a><?php endif; ?>
            <?php if (!empty($site_settings['header_contact_email'])): ?><a href="mailto:<?php echo htmlspecialchars($site_settings['header_contact_email']); ?>" class="text-white"><i class="bi bi-envelope-fill me-1"></i> <?php echo htmlspecialchars($site_settings['header_contact_email']); ?></a><?php endif; ?>
        </div>
    </div>
</div>

<?php if (!empty($site_settings['notification_banner_text']) && $site_settings['notification_banner_status'] === 'active'): ?>
<div class="notification-banner" id="notificationBanner"><p><?php echo htmlspecialchars($site_settings['notification_banner_text']); ?></p><button class="close-btn" onclick="document.getElementById('notificationBanner').style.display='none';">&times;</button></div>
<?php endif; ?>

<nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm sticky-top">
    <div class="container">
        <a class="navbar-brand" href="index.php">
            <?php if (!empty($site_settings['site_logo_url'])): ?>
                <img src="<?php echo htmlspecialchars($site_settings['site_logo_url']); ?>" alt="<?php echo htmlspecialchars($site_settings['site_name'] ?? 'Site Logo'); ?>" style="max-height: 40px;">
            <?php else: ?>
                <strong><?php echo htmlspecialchars($site_settings['site_name'] ?? 'DXP'); ?></strong>
            <?php endif; ?>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#main-nav"><span class="navbar-toggler-icon"></span></button>
        <div class="collapse navbar-collapse" id="main-nav">
            <ul class="navbar-nav mx-auto mb-2 mb-lg-0"><li class="nav-item"><a class="nav-link <?php echo ($current_page == 'index.php') ? 'active' : ''; ?>" href="index.php">Home</a></li><li class="nav-item"><a class="nav-link <?php echo ($current_page == 'tours.php') ? 'active' : ''; ?>" href="tours.php">Tours</a></li><li class="nav-item"><a class="nav-link <?php echo ($current_page == 'hotels.php') ? 'active' : ''; ?>" href="hotels.php">Hotels</a></li><li class="nav-item"><a class="nav-link <?php echo ($current_page == 'contact.php') ? 'active' : ''; ?>" href="contact.php">Contact</a></li></ul>
            <div class="d-flex">
                <?php if (isset($_SESSION['user_id'])): ?>
                    <a href="dashboard/index.php" class="btn btn-primary me-2"><i class="bi bi-person-circle"></i> My Dashboard</a><a href="logout.php" class="btn btn-outline-secondary">Logout</a>
                <?php else: ?>
                    <a href="login.php" class="btn btn-outline-primary me-2">Login</a><a href="register.php" class="btn btn-primary">Register</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</nav>

<main>
