<?php 
include 'includes/header.php'; 

// Fetch all visible FAQs from the database, ordered by display_order
$faq_result = $conn->query("SELECT * FROM faqs WHERE is_visible = 1 ORDER BY display_order ASC");
?>

<main class="container my-5">
    <div class="text-center mb-5">
        <h1 class="display-4">Frequently Asked Questions</h1>
        <p class="lead">Have a question? We've got answers. If you can't find what you are looking for, please don't hesitate to contact us.</p>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-9">
            <?php if ($faq_result && $faq_result->num_rows > 0): ?>
                <div class="accordion" id="faqAccordion">
                    <?php while($faq = $faq_result->fetch_assoc()): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading<?php echo $faq['id']; ?>">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $faq['id']; ?>" aria-expanded="false" aria-controls="collapse<?php echo $faq['id']; ?>">
                                <?php echo htmlspecialchars($faq['question']); ?>
                            </button>
                        </h2>
                        <div id="collapse<?php echo $faq['id']; ?>" class="accordion-collapse collapse" aria-labelledby="heading<?php echo $faq['id']; ?>" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                <?php echo nl2br(htmlspecialchars($faq['answer'])); ?>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-info">No frequently asked questions have been added yet.</div>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>
