<?php 
include 'includes/header.php'; 
$dest_id = intval($_GET['id'] ?? 0);
if ($dest_id <= 0) { header("Location: destinations.php"); exit(); }

$stmt = $conn->prepare("SELECT * FROM destinations WHERE id = ?");
$stmt->bind_param("i", $dest_id);
$stmt->execute();
$destination = $stmt->get_result()->fetch_assoc();
if (!$destination) { header("Location: destinations.php"); exit(); }

// Fetch related tours and hotels
$search_term = "%" . $destination['name'] . "%";
$related_tours = $conn->prepare("SELECT * FROM tours WHERE location LIKE ? LIMIT 3");
$related_tours->bind_param("s", $search_term);
$related_tours->execute();
$tours_result = $related_tours->get_result();
?>
<main>
    <div class="p-5 mb-4 bg-light rounded-3" style="background-image: linear-gradient(rgba(0,0,0,0.5), rgba(0,0,0,0.5)), url('<?php echo htmlspecialchars($destination['hero_image_url']); ?>'); background-size: cover; background-position: center;">
        <div class="container-fluid py-5 text-white">
            <h1 class="display-5 fw-bold"><?php echo htmlspecialchars($destination['name']); ?></h1>
            <p class="col-md-8 fs-4"><?php echo htmlspecialchars($destination['short_description']); ?></p>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <article><?php echo $destination['full_guide']; ?></article>
            </div>
            <div class="col-lg-4">
                <?php if ($tours_result->num_rows > 0): ?>
                <div class="card"><div class="card-header">Tours in <?php echo htmlspecialchars($destination['name']); ?></div>
                    <div class="list-group list-group-flush">
                    <?php while ($tour = $tours_result->fetch_assoc()): ?>
                        <a href="service-details.php?id=<?php echo $tour['id']; ?>" class="list-group-item list-group-item-action"><?php echo htmlspecialchars($tour['title']); ?></a>
                    <?php endwhile; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
