<?php
require_once 'header.php'; 
$page_title = 'Leave a Review';

// --- Handle Form Submission ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $item_id = filter_input(INPUT_POST, 'item_id', FILTER_VALIDATE_INT);
    $item_type = $_POST['item_type'] ?? 'tour'; // 'tour' or 'hotel'
    $rating = filter_input(INPUT_POST, 'rating', FILTER_VALIDATE_INT);
    $review_text = trim($_POST['review_text'] ?? '');
    $image_url = null; // Default to null

    // --- Image Upload Logic ---
    if (isset($_FILES['review_image']) && $_FILES['review_image']['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES['review_image'];
        $upload_dir = '../uploads/reviews/';
        if (!is_dir($upload_dir)) { mkdir($upload_dir, 0755, true); }
        
        // Create a unique, safe filename
        $filename = uniqid('review_', true) . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
        $target_path = $upload_dir . $filename;

        // Move the uploaded file
        if (move_uploaded_file($file['tmp_name'], $target_path)) {
            $image_url = 'uploads/reviews/' . $filename;
        }
    }
    // --- End Image Upload Logic ---

    if ($item_id && $rating > 0 && !empty($review_text)) {
        $stmt = $conn->prepare("INSERT INTO user_reviews (user_id, item_id, item_type, rating, review_text, image_url) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iisiss", $user_id, $item_id, $item_type, $rating, $review_text, $image_url);
        $stmt->execute();
        $stmt->close();
        
        $_SESSION['success_message'] = "Thank you! Your review has been submitted for approval.";
        header("Location: my-reviews.php");
        exit();
    } else {
        $error_message = "Please fill in all required fields.";
    }
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-star-fill me-2"></i>Leave a Review</h1>
</div>

<?php if (isset($error_message)): ?>
<div class="alert alert-danger"><?php echo $error_message; ?></div>
<?php endif; ?>

<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card shadow-sm border-0">
            <div class="card-body p-4">
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="item_id" value="1"> 
                    <input type="hidden" name="item_type" value="tour">

                    <div class="mb-3">
                        <label class="form-label">Your Rating</label>
                        <div>
                            <div class="form-check form-check-inline fs-4">
                                <?php for ($i = 5; $i >= 1; $i--): ?>
                                    <input type="radio" class="btn-check" name="rating" id="rating-<?php echo $i; ?>" value="<?php echo $i; ?>" required>
                                    <label class="btn btn-outline-warning" for="rating-<?php echo $i; ?>"><i class="bi bi-star-fill"></i></label>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="review_text" class="form-label">Your Review</label>
                        <textarea class="form-control" id="review_text" name="review_text" rows="6" required></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="review_image" class="form-label">Upload a Picture (Optional)</label>
                        <input class="form-control" type="file" id="review_image" name="review_image" accept="image/jpeg, image/png">
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary btn-lg">Submit Review</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?>
