<?php
require_once 'header.php'; 
$page_title = 'Affiliate Program';

// --- PAGE-SPECIFIC QUERIES ---

// 1. Get the user's affiliate data (already in the $user array from the header)
$affiliate_code = $user['affiliate_code'] ?? null;
$affiliate_earnings = $user['affiliate_earnings'] ?? 0.00;

// 2. Construct the user's unique referral link
$referral_link = $site_settings['site_url'] . '/register.php?ref=' . $affiliate_code;

// 3. Fetch a list of users who were referred by the current user
$stmt = $conn->prepare("SELECT full_name, created_at FROM users WHERE referred_by_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$referrals = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-people-fill me-2"></i>Affiliate Program</h1>
</div>

<div class="row">
    <div class="col-lg-7 mb-4">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body p-4">
                <h5 class="card-title">Share Your Link & Earn</h5>
                <p class="text-muted">Invite friends to book with us using your unique referral link. You'll earn a commission for every successful booking they make!</p>
                
                <label for="referralLink" class="form-label fw-bold">Your Unique Referral Link</label>
                <div class="input-group">
                    <input type="text" class="form-control" id="referralLink" value="<?php echo htmlspecialchars($referral_link); ?>" readonly>
                    <button class="btn btn-outline-primary" type="button" id="copyBtn" title="Copy to Clipboard">
                        <i class="bi bi-clipboard-check-fill"></i>
                    </button>
                </div>
                <div id="copyAlert" class="form-text text-success d-none">Link copied to clipboard!</div>
            </div>
        </div>
    </div>
    <div class="col-lg-5 mb-4">
        <div class="card shadow-sm border-0 h-100">
            <div class="card-body text-center p-4">
                <p class="text-muted mb-1 mt-2">Total Earnings</p>
                <h2 class="display-5 fw-bold mb-3 text-success"><?php echo format_price($affiliate_earnings); ?></h2>
                <div class="d-grid">
                    <button class="btn btn-success" disabled>Request Payout (Coming Soon)</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-header bg-light border-0 pt-3">
        <h5 class="mb-0">Your Referrals (<?php echo count($referrals); ?>)</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Date Joined</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($referrals)): ?>
                        <tr>
                            <td colspan="2" class="text-center p-5">
                                <i class="bi bi-person-plus fs-2 text-muted"></i>
                                <p class="mt-2 mb-0 text-muted">You haven't referred anyone yet. Share your link to get started!</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($referrals as $ref): ?>
                        <tr>
                            <td class="fw-bold"><?php echo htmlspecialchars($ref['full_name']); ?></td>
                            <td><?php echo date('F j, Y', strtotime($ref['created_at'])); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const copyBtn = document.getElementById('copyBtn');
    const referralLinkInput = document.getElementById('referralLink');
    const copyAlert = document.getElementById('copyAlert');

    copyBtn.addEventListener('click', function() {
        referralLinkInput.select();
        document.execCommand('copy');
        
        copyAlert.classList.remove('d-none');
        setTimeout(function() {
            copyAlert.classList.add('d-none');
        }, 2000);
    });
});
</script>


<?php 
require_once 'footer.php'; 
?>
