<?php
// 1. INCLUDE THE DASHBOARD HEADER
// Handles security, DB connection, user data, and the top navbar.
include 'header.php';

// --- Page-Specific Logic Starts Here ---
// The $user_id variable is available from header.php

// 2. HANDLE PASSWORD CHANGE FORM SUBMISSION
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'change_password') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $_SESSION['error_message'] = "Please fill in all password fields.";
    } elseif (strlen($new_password) < 8) {
        $_SESSION['error_message'] = "New password must be at least 8 characters long.";
    } elseif ($new_password !== $confirm_password) {
        $_SESSION['error_message'] = "New passwords do not match.";
    } else {
        // Fetch the user's current hashed password
        $stmt_pass = $conn->prepare("SELECT password FROM users WHERE id = ?");
        $stmt_pass->bind_param("i", $user_id);
        $stmt_pass->execute();
        $user_data = $stmt_pass->get_result()->fetch_assoc();
        $stmt_pass->close();

        // Verify the current password is correct
        if ($user_data && password_verify($current_password, $user_data['password'])) {
            // Hash the new password and update it in the database
            $new_password_hash = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt_update = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            $stmt_update->bind_param("si", $new_password_hash, $user_id);
            if ($stmt_update->execute()) {
                $_SESSION['success_message'] = "Password changed successfully!";
            } else {
                $_SESSION['error_message'] = "Error changing password.";
            }
            $stmt_update->close();
        } else {
            $_SESSION['error_message'] = "Incorrect current password.";
        }
    }
    // Redirect back to the security page to show the message
    header("Location: security.php");
    exit();
}
?>

<div class="container my-5">
    <div class="dashboard-content">
        <h1 class="h2 mb-4">Account Security</h1>

        <?php if (isset($_SESSION['success_message'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['error_message'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert"><?php echo $_SESSION['error_message']; unset($_SESSION['error_message']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
        <?php endif; ?>

        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bi bi-key-fill me-2"></i>Change Password</h5>
                    </div>
                    <div class="card-body p-4">
                        <form action="security.php" method="POST">
                            <input type="hidden" name="action" value="change_password">
                            <div class="mb-3">
                                <label for="current_password" class="form-label">Current Password</label>
                                <input type="password" class="form-control" id="current_password" name="current_password" required>
                            </div>
                            <div class="mb-3">
                                <label for="new_password" class="form-label">New Password</label>
                                <input type="password" class="form-control" id="new_password" name="new_password" required>
                                <div class="form-text">Must be at least 8 characters long.</div>
                            </div>
                            <div class="mb-3">
                                <label for="confirm_password" class="form-label">Confirm New Password</label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                            </div>
                            <div class="d-flex justify-content-end mt-4">
                                <button type="submit" class="btn btn-primary">Update Password</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card shadow-sm">
                     <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bi bi-shield-check me-2"></i>Security Tips</h5>
                    </div>
                    <div class="card-body">
                       <ul class="list-unstyled">
                           <li class="mb-3 d-flex">
                               <i class="bi bi-check-circle-fill text-success mt-1 me-2"></i>
                               <div>
                                   <strong>Use a strong password.</strong><br>
                                   Combine uppercase, lowercase, numbers, and symbols.
                               </div>
                           </li>
                           <li class="mb-3 d-flex">
                               <i class="bi bi-check-circle-fill text-success mt-1 me-2"></i>
                               <div>
                                   <strong>Don't reuse passwords.</strong><br>
                                   Use a unique password for this site to protect your account.
                               </div>
                           </li>
                            <li class="d-flex">
                               <i class="bi bi-check-circle-fill text-success mt-1 me-2"></i>
                               <div>
                                   <strong>Log out after use.</strong><br>
                                   Always log out of your account on shared devices.
                               </div>
                           </li>
                       </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php include '../includes/footer.php'; ?>
