<?php
// STEP 1: Handle all setup, security, and global data
require_once 'dashboard-logic.php';

// STEP 2: Set the page-specific title
$page_title = 'Dashboard Overview';

// STEP 3: Display the new header/layout
require_once 'header.php'; 

// --- All PHP logic to fetch dashboard data remains the same ---
// ...

// 1. Dynamic Greeting
date_default_timezone_set('Asia/Manila');
$current_hour = (int)date('G');
if ($current_hour < 12) { $greeting = "Good morning"; } 
elseif ($current_hour < 18) { $greeting = "Good afternoon"; } 
else { $greeting = "Good evening"; }

// (Example queries for widgets would be here)
?>

<div class="pb-2 mb-4 border-bottom">
    <h1 class="h2"><?php echo $greeting; ?>, <?php echo htmlspecialchars(strtok($user_name, ' ')); ?>!</h1>
    <p class="text-muted">Welcome back to your dashboard. Let's plan your next adventure.</p>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card shadow-sm mb-4">
             <div class="card-header bg-primary text-white"><h5 class="mb-0"><i class="bi bi-pin-map-fill me-2"></i>Your Next Adventure</h5></div>
             <div class="card-body p-4 text-center"><p class="text-muted">Your next upcoming trip details will be displayed here.</p></div>
        </div>
        
        <h4 class="mb-3">Recommended For You</h4>
        </div>

    <div class="col-lg-4">
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-body text-center p-4">
                <i class="bi bi-wallet2 fs-1 text-success"></i>
                <p class="text-muted mb-1 mt-2">Wallet Balance</p>
                <h3 class="fw-bold mb-3">$0.00</h3>
                <div class="d-grid gap-2">
                    <a href="wallet.php" class="btn btn-success">Manage Wallet</a>
                    <a href="top-up.php" class="btn btn-outline-success">Top-Up Now</a>
                </div>
            </div>
        </div>
        </div>
</div>

<?php 
// STEP 4: Display the footer
require_once 'footer.php'; 
?>
