<?php
// Note: This file should be included AFTER dashboard-logic.php
$current_page = basename($_SERVER['SCRIPT_NAME']);

// --- Currency Switcher Logic ---
// Fetch all active currencies for the dropdown
$currencies_result = $conn->query("SELECT code, symbol FROM currencies WHERE is_active = 1 ORDER BY code ASC");
$available_currencies = $currencies_result->fetch_all(MYSQLI_ASSOC);

// Determine the current currency to display
$current_currency_code = $_SESSION['currency'] ?? ($site_settings['site_base_currency'] ?? 'PHP');
$current_currency_symbol = '₱'; // Default symbol
foreach ($available_currencies as $currency) {
    if ($currency['code'] === $current_currency_code) {
        $current_currency_symbol = $currency['symbol'];
        break;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) . ' - Dashboard' : 'My Dashboard'; ?></title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="../css/style.css">

    <style>
        body {
            background-color: #F9FAFB;
        }
        .top-navbar {
            background-color: #ffffff;
            border-bottom: 1px solid #dee2e6;
        }
        .navbar-brand img {
            max-height: 35px;
        }
        .user-menu .dropdown-toggle::after {
            display: none;
        }
        .user-menu .dropdown-menu {
            width: 260px;
            border-radius: var(--bs-border-radius);
            border: 1px solid #dee2e6;
        }
    </style>
</head>
<body>

<header class="navbar navbar-light sticky-top top-navbar p-2 shadow-sm">
    <div class="container-fluid">
        <a class="navbar-brand" href="../index.php">
            <?php if (!empty($site_settings['site_logo_url'])): ?>
                <img src="../<?php echo htmlspecialchars($site_settings['site_logo_url']); ?>" alt="Site Logo">
            <?php endif; ?>
        </a>

        <div class="d-flex align-items-center">
            <div class="nav-item dropdown me-3">
                <a class="nav-link dropdown-toggle btn btn-light btn-sm" href="#" id="currencyDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <strong><?php echo htmlspecialchars($current_currency_code); ?></strong>
                </a>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="currencyDropdown">
                    <?php foreach ($available_currencies as $currency): ?>
                        <li>
                            <a class="dropdown-item" href="../set-currency.php?currency=<?php echo htmlspecialchars($currency['code']); ?>">
                                <?php echo htmlspecialchars($currency['symbol']); ?> <?php echo htmlspecialchars($currency['code']); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            
            <div class="nav-item dropdown user-menu">
                <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userMenuDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <span class="d-none d-sm-inline mx-2"><?php echo htmlspecialchars(strtok($user_name, ' ')); ?></span>
                    <i class="bi bi-person-circle fs-2"></i>
                </a>
                <ul class="dropdown-menu dropdown-menu-end p-2" aria-labelledby="userMenuDropdown">
                    <li><h6 class="dropdown-header">Navigation</h6></li>
                    <li><a class="dropdown-item rounded <?php echo ($current_page == 'index.php') ? 'active' : ''; ?>" href="index.php"><i class="bi bi-grid-fill me-2"></i> Dashboard</a></li>
                    <li><a class="dropdown-item rounded <?php echo ($current_page == 'my-bookings.php') ? 'active' : ''; ?>" href="my-bookings.php"><i class="bi bi-briefcase-fill me-2"></i> My Bookings</a></li>
                    <li><a class="dropdown-item rounded <?php echo ($current_page == 'wallet.php') ? 'active' : ''; ?>" href="wallet.php"><i class="bi bi-wallet2 me-2"></i> My Wallet</a></li>
                    <li><a class="dropdown-item rounded <?php echo ($current_page == 'wishlist.php') ? 'active' : ''; ?>" href="wishlist.php"><i class="bi bi-heart-fill me-2"></i> My Wishlist</a></li>
                    <li><a class="dropdown-item rounded <?php echo ($current_page == 'messages.php') ? 'active' : ''; ?>" href="messages.php"><i class="bi bi-chat-left-text-fill me-2"></i> Messages</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><h6 class="dropdown-header">Account</h6></li>
                    <li><a class="dropdown-item rounded <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php"><i class="bi bi-person-circle me-2"></i> My Profile</a></li>
                    <li><a class="dropdown-item rounded <?php echo ($current_page == 'support.php') ? 'active' : ''; ?>" href="support.php"><i class="bi bi-question-circle-fill me-2"></i> Support</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item rounded text-danger" href="../logout.php"><i class="bi bi-box-arrow-right me-2"></i> Sign Out</a></li>
                </ul>
            </div>
        </div>
    </div>
</header>

<main class="container py-4">
