<?php
// STEP 1: START THE SESSION
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// STEP 2: INCLUDE THE DATABASE CONNECTION
require_once __DIR__ . '/../includes/db.php';

// --- NEW LINE TO FIX THE ERROR ---
// STEP 3: INCLUDE HELPER FUNCTIONS (like format_price)
require_once __DIR__ . '/../includes/helpers.php';

// STEP 4: SECURITY CHECK - REDIRECT GUESTS
if (!isset($_SESSION['user_id'])) {
    header('Location: ../login.php');
    exit();
}

// STEP 5: FETCH LOGGED-IN USER DATA
$user_id = $_SESSION['user_id'];
$user_name = 'Customer';
if ($stmt = $conn->prepare("SELECT full_name FROM users WHERE id = ?")) {
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $user_result = $stmt->get_result()->fetch_assoc();
    if ($user_result) {
        $user_name = $user_result['full_name'];
    }
    $stmt->close();
}
