<?php if (!isset($booking) || !isset($site_settings)) { die('Required data is missing.'); } ?>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <style>
        @page { margin: 0; }
        body { font-family: 'DejaVu Sans', sans-serif; font-size: 12px; color: #333; margin: 0; }
        .ticket { width: 100%; max-width: 800px; min-height: 320px; margin: 20px auto; border: 1px solid #ddd; display: table; table-layout: fixed; box-shadow: 0 0 10px rgba(0,0,0,0.1); border-radius: 10px; overflow: hidden; }
        .main { width: 70%; display: table-cell; padding: 25px; vertical-align: top; }
        .stub { width: 30%; display: table-cell; vertical-align: top; border-left: 2px dashed #ccc; text-align: center; padding: 25px; background-color: #f9f9f9; }
        .header { background-color: <?php echo htmlspecialchars($site_settings['ticket_header_color'] ?? '#0d6efd'); ?>; color: white; padding: 15px 25px; text-align: left; margin: -25px -25px 20px -25px; display: table; width: 100%;}
        .header img { max-height: 40px; display: table-cell; vertical-align: middle; }
        .header h2 { display: table-cell; vertical-align: middle; font-size: 18px; padding-left: 15px; text-transform: uppercase; }
        .info-block { margin-bottom: 20px; }
        .info-block h4 { color: #888; font-size: 11px; margin-bottom: 2px; text-transform: uppercase; letter-spacing: 0.5px; }
        .info-block p { font-size: 16px; font-weight: bold; margin: 0; }
        .notes { font-size: 10px; color: #777; line-height: 1.5; }
    
        .itinerary { border: 1px solid #eee; padding: 10px; background-color: #fafafa; border-radius: 5px; font-size: 11px; }
        pre { font-family: 'DejaVu Sans', sans-serif; white-space: pre-wrap; margin: 0; }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="main">
            <div class="header">
                <?php if (!empty($site_settings['site_logo_url'])): ?><img src="<?php echo $_SERVER['DOCUMENT_ROOT'] . '/' . strtok($site_settings['site_logo_url'], '?'); ?>"><?php endif; ?>
                <h2>Flight Itinerary</h2>
            </div>
            <table style="width:100%; margin-bottom: 15px;"><tr>
                <td style="width:50%; vertical-align: top;">
                    <h4>FROM</h4>
                    <p><?php echo htmlspecialchars($booking['origin_city']); ?></p>
                </td>
                <td style="width:50%; vertical-align: top;">
                    <h4>TO</h4>
                    <p><?php echo htmlspecialchars($booking['dest_city']); ?></p>
                </td>
            </tr></table>
            <div class="info-block">
                <h4>PASSENGER</h4>
                <p><?php echo htmlspecialchars($booking['full_name']); ?></p>
            </div>
            <div class="info-block itinerary">
                <pre><?php echo htmlspecialchars($booking['admin_notes']); ?></pre>
            </div>
        </div>
        <div class="stub">
            <p style="font-size: 12px; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['origin_city'] . ' → ' . $booking['dest_city']); ?></p>
            <h4>PASSENGER</h4>
            <p style="font-size: 12px; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['full_name']); ?></p>
            <h4>BOOKING ID</h4>
            <p style="font-size: 14px; font-weight: bold; margin-bottom: 15px;">#<?php echo $booking['id']; ?></p>
            <img src="<?php echo $qr_code_path; ?>" style="width: 100px; height: 100px;">
            <p class="notes" style="margin-top: 10px;">Scan to verify</p>
        </div>
    </div>
</body>
</html>
