<?php 
include 'includes/header.php';

// --- FILTERING & SEARCH LOGIC ---
$category_filter = $_GET['category'] ?? 'all';
$search_keyword = trim($_GET['keyword'] ?? '');

$sql = "SELECT t.*, u.is_verified as partner_verified 
        FROM tours t 
        LEFT JOIN users u ON t.partner_id = u.id";
$params = [];
$param_types = '';
$conditions = [];

// Category Filter
if ($category_filter == 'tours') {
    $conditions[] = "t.category = 'Tour'";
} elseif ($category_filter == 'services') {
    $conditions[] = "t.category = 'Service'";
}

// Keyword Search
if (!empty($search_keyword)) {
    $conditions[] = "(t.title LIKE ? OR t.location LIKE ? OR t.description LIKE ?)";
    $like_term = "%" . $search_keyword . "%";
    $params = [$like_term, $like_term, $like_term];
    $param_types = 'sss';
}

if (!empty($conditions)) {
    $sql .= " WHERE " . implode(' AND ', $conditions);
}

$sql .= " ORDER BY t.is_featured DESC, t.title ASC";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($param_types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<main class="container my-5">
    <div class="text-center mb-4">
        <h1 class="display-4">Our Tours & Services</h1>
        <?php if (!empty($search_keyword)): ?>
            <p class="lead">Showing <?php echo $result->num_rows; ?> results for "<?php echo htmlspecialchars($search_keyword); ?>". <a href="services.php">Clear search.</a></p>
        <?php else: ?>
            <p class="lead">Unforgettable experiences and convenient services curated by local experts.</p>
        <?php endif; ?>
    </div>

    <ul class="nav nav-pills justify-content-center mb-5">
        <li class="nav-item"><a class="nav-link <?php if($category_filter == 'all') echo 'active'; ?>" href="services.php">All</a></li>
        <li class="nav-item"><a class="nav-link <?php if($category_filter == 'tours') echo 'active'; ?>" href="services.php?category=tours">Tours</a></li>
        <li class="nav-item"><a class="nav-link <?php if($category_filter == 'services') echo 'active'; ?>" href="services.php?category=services">Services</a></li>
    </ul>

    <div class="row">
        <?php if ($result->num_rows > 0): while($row = $result->fetch_assoc()): ?>
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card h-100 tour-card shadow-sm">
                    <a href="service-details.php?id=<?php echo $row['id']; ?>">
                        <img src="<?php echo htmlspecialchars($row['image_url']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($row['title']); ?>">
                    </a>
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title"><?php echo htmlspecialchars($row['title']); ?></h5>
                        <?php if ($row['partner_verified']): ?>
                            <div class="mb-2"><span class="verified-badge"><i class="bi bi-patch-check-fill"></i> Verified Partner</span></div>
                        <?php endif; ?>
                        <p class="card-text text-muted"><i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($row['location']); ?></p>
                        <h6 class="card-subtitle mb-3 fw-bold">From ₱<?php echo number_format($row['price'], 2); ?></h6>
                        <a href="service-details.php?id=<?php echo $row['id']; ?>" class="btn btn-primary mt-auto">View Details</a>
                    </div>
                </div>
            </div>
        <?php endwhile; else: ?>
            <div class="col-12">
                <div class="alert alert-info text-center">No tours or services found matching your criteria.</div>
            </div>
        <?php endif; ?>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
