<?php
// --- LOGIC BLOCK ---
include 'includes/header.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: services.php");
    exit();
}
$item_id = intval($_GET['id']);

// Fetch main item details and partner's verification status
$stmt_item = $conn->prepare("
    SELECT t.*, u.is_verified as partner_verified 
    FROM tours t 
    LEFT JOIN users u ON t.partner_id = u.id 
    WHERE t.id = ?");
$stmt_item->bind_param("i", $item_id);
$stmt_item->execute();
$item_result = $stmt_item->get_result();
if ($item_result->num_rows === 0) {
    include 'includes/footer.php';
    exit("<main class='container my-5'><div class='alert alert-danger'>Sorry, the requested item could not be found.</div></main>");
}
$item = $item_result->fetch_assoc();

// Fetch gallery images
$stmt_gallery = $conn->prepare("SELECT * FROM galleries WHERE item_id = ? AND item_type = 'tour' ORDER BY id ASC");
$stmt_gallery->bind_param("i", $item_id);
$stmt_gallery->execute();
$gallery_images = $stmt_gallery->get_result()->fetch_all(MYSQLI_ASSOC);

// Fetch visible reviews
$stmt_reviews = $conn->prepare("SELECT * FROM reviews WHERE item_id = ? AND item_type = 'tour' AND is_visible = 1 ORDER BY id DESC");
$stmt_reviews->bind_param("i", $item_id);
$stmt_reviews->execute();
$reviews_result = $stmt_reviews->get_result();

// Prepare variables for social media sharing
$page_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$share_title = urlencode("Check out: " . $item['title']);
$page_url_encoded = urlencode($page_url);

// --- PRESENTATION BLOCK ---
?>
<main class="container my-5">
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div id="itemCarousel" class="carousel slide shadow-lg rounded" data-bs-ride="carousel">
                <div class="carousel-inner rounded">
                    <div class="carousel-item active"><img src="<?php echo htmlspecialchars($item['image_url']); ?>" class="d-block w-100 tour-details-img" alt="Main image"></div>
                    <?php foreach ($gallery_images as $img): ?>
                    <div class="carousel-item"><img src="<?php echo htmlspecialchars($img['image_url']); ?>" class="d-block w-100 tour-details-img" alt="Gallery image"></div>
                    <?php endforeach; ?>
                </div>
                <?php if (count($gallery_images) > 0): ?>
                <button class="carousel-control-prev" type="button" data-bs-target="#itemCarousel" data-bs-slide="prev"><span class="carousel-control-prev-icon"></span></button>
                <button class="carousel-control-next" type="button" data-bs-target="#itemCarousel" data-bs-slide="next"><span class="carousel-control-next-icon"></span></button>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-lg-4 mb-4">
            <div class="card shadow-sm sticky-top" style="top: 80px;">
                <div class="card-body">
                    <h3 class="card-title"><?php echo $item['category'] == 'Service' ? 'Avail This Service' : 'Book This Tour'; ?></h3>
                    <h4 class="text-primary">₱<?php echo number_format($item['price'], 2); ?></h4>
                    <hr>
                    <form action="booking.php" method="POST">
                        <input type="hidden" name="tour_id" value="<?php echo $item['id']; ?>">
                        <div class="row">
                            <div class="col-md-3 mb-3"><label class="form-label">Title</label><select name="customer_title" class="form-select"><option value="Mr.">Mr.</option><option value="Ms.">Ms.</option><option value="Mrs.">Mrs.</option></select></div>
                            <div class="col-md-6 mb-3"><label class="form-label">Full Name</label><input type="text" class="form-control" name="customer_name" required></div>
                            <div class="col-md-3 mb-3"><label class="form-label">Suffix</label><input type="text" class="form-control" name="customer_suffix" placeholder="e.g., Jr."></div>
                        </div>
                        <div class="mb-3"><label class="form-label">Email Address</label><input type="email" class="form-control" name="customer_email" required></div>
                        <div class="mb-3"><label class="form-label">Phone Number</label><input type="tel" class="form-control" name="customer_phone" required></div>
                        <div class="mb-3"><label class="form-label">Preferred Date</label><input type="date" class="form-control" name="booking_date" required min="<?php echo date('Y-m-d'); ?>"></div>
                        <div class="mb-3"><label class="form-label"><?php echo $item['category'] == 'Service' ? 'Quantity' : 'Travelers'; ?></label><input type="number" class="form-control" name="num_travelers" min="1" value="1" required></div>
                        <div class="d-grid"><button type="submit" class="btn btn-primary btn-lg">Book Now</button></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-12">
             <h1 class="d-inline-block me-2"><?php echo htmlspecialchars($item['title']); ?></h1>
            <?php if ($item['partner_verified']): ?><span class="verified-badge fs-6"><i class="bi bi-patch-check-fill"></i> Verified Partner</span><?php endif; ?>
            <p class="lead">
                <i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($item['location']); ?>
                <?php if ($item['duration_days'] > 0): ?> | <i class="bi bi-clock-fill"></i> <?php echo htmlspecialchars($item['duration_days']); ?> Day(s)<?php endif; ?>
            </p>
            <hr>
            <h4>Description</h4>
            <p><?php echo nl2br(htmlspecialchars($item['description'])); ?></p>
        </div>
    </div>
    
    <?php if ($item['category'] == 'Tour'): ?>
    <hr class="my-5">
    <h2 class="mb-4">Customer Reviews</h2>
    <div class="row">
        <?php if($reviews_result->num_rows > 0): while($review = $reviews_result->fetch_assoc()): ?>
        <div class="col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h5 class="card-title mb-0"><?php echo htmlspecialchars($review['display_name_publicly'] ? $review['customer_name'] : 'A Verified Traveler'); ?></h5>
                        <?php if ($review['is_verified']): ?><span class="badge bg-success"><i class="bi bi-patch-check-fill"></i> Verified Booking</span><?php endif; ?>
                    </div>
                    <div class="text-warning mb-2"><?php for ($i=0; $i < $review['rating']; $i++): ?><i class="bi bi-star-fill"></i><?php endfor; ?></div>
                    <p class="card-text fst-italic">"<?php echo nl2br(htmlspecialchars($review['review_text'])); ?>"</p>
                </div>
            </div>
        </div>
        <?php endwhile; else: ?><p class="text-muted">No reviews for this tour yet.</p><?php endif; ?>
    </div>
    <?php endif; ?>
</main>
<?php include 'includes/footer.php'; ?>
