<?php
include 'header.php';
// Security: This page is for HOTEL partners only
if ($partner_role !== 'hotel_partner') { die("Access Denied."); }

$hotel_id = intval($_GET['hotel_id'] ?? 0);
// Security Check: Ensure the hotel belongs to this partner
$stmt_hotel = $conn->prepare("SELECT name FROM hotels WHERE id = ? AND partner_id = ?");
$stmt_hotel->bind_param("ii", $hotel_id, $partner_id);
$stmt_hotel->execute();
$hotel = $stmt_hotel->get_result()->fetch_assoc();
if (!$hotel) { header("Location: manage-hotels.php"); exit(); }
$hotel_name = $hotel['name'];

$message = '';
// ACTION HANDLING for rooms and rates
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Add or Edit a Room Type
    if (isset($_POST['save_room'])) {
        $room_type_name = trim($_POST['room_type_name']);
        $description = trim($_POST['description']);
        $max_occupancy = intval($_POST['max_occupancy']);
        $stmt = $conn->prepare("INSERT INTO hotel_rooms (hotel_id, room_type_name, description, max_occupancy) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("issi", $hotel_id, $room_type_name, $description, $max_occupancy);
        $stmt->execute();
        $message = '<div class="alert alert-success">New room type added. Now you can add rates to it below.</div>';
    }
    // Add a Rate to a Room
    if (isset($_POST['save_rate'])) {
        $room_id = intval($_POST['room_id']);
        $rate_name = trim($_POST['rate_name']);
        $price_per_night = floatval($_POST['price_per_night']);
        $stmt = $conn->prepare("INSERT INTO hotel_room_rates (room_id, rate_name, price_per_night) VALUES (?, ?, ?)");
        $stmt->bind_param("isd", $room_id, $rate_name, $price_per_night);
        $stmt->execute();
        $message = '<div class="alert alert-success">New rate added successfully.</div>';
    }
}
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage Rooms & Rates for: <span class="text-primary"><?php echo htmlspecialchars($hotel_name); ?></span></h1>
    <a href="manage-hotels.php" class="btn btn-secondary">← Back to Hotels List</a>
</div>
<?php echo $message; ?>

<div class="row">
    <div class="col-lg-4 mb-4">
        <div class="card shadow-sm"><div class="card-header">Add New Room Type</div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3"><label>Room Name</label><input type="text" name="room_type_name" class="form-control" placeholder="e.g., Deluxe Double" required></div>
                    <div class="mb-3"><label>Occupancy</label><input type="number" name="max_occupancy" class="form-control" placeholder="e.g., 2" required></div>
                    <div class="mb-3"><label>Description</label><textarea name="description" class="form-control" rows="3"></textarea></div>
                    <button type="submit" name="save_room" class="btn btn-primary">Add Room</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8 mb-4">
        <div class="card shadow-sm"><div class="card-header">Existing Rooms & Rates</div>
            <div class="list-group list-group-flush">
            <?php
            $rooms_result = $conn->query("SELECT * FROM hotel_rooms WHERE hotel_id = $hotel_id");
            if ($rooms_result->num_rows > 0): while($room = $rooms_result->fetch_assoc()):
            ?>
                <div class="list-group-item">
                    <h5 class="mb-1"><?php echo htmlspecialchars($room['room_type_name']); ?></h5>
                    <p class="mb-2"><i class="bi bi-people-fill"></i> Good for <?php echo $room['max_occupancy']; ?></p>
                    <ul class="list-unstyled">
                    <?php $rates_result = $conn->query("SELECT * FROM hotel_room_rates WHERE room_id = ".$room['id']);
                          while($rate = $rates_result->fetch_assoc()): ?>
                        <li class="d-flex justify-content-between border-top py-2">
                            <span><?php echo htmlspecialchars($rate['rate_name']); ?></span>
                            <strong class="text-success">₱<?php echo number_format($rate['price_per_night'], 2); ?> / night</strong>
                        </li>
                    <?php endwhile; ?>
                    </ul>
                    <form method="POST" class="d-flex gap-2 mt-2 pt-2 border-top">
                        <input type="hidden" name="room_id" value="<?php echo $room['id']; ?>">
                        <input type="text" name="rate_name" class="form-control form-control-sm" placeholder="Rate Name (e.g., Flexible Rate)" required>
                        <input type="number" name="price_per_night" class="form-control form-control-sm" placeholder="Price" step="0.01" required>
                        <button type="submit" name="save_rate" class="btn btn-secondary btn-sm">Add Rate</button>
                    </form>
                </div>
            <?php endwhile; else: echo '<div class="list-group-item text-muted text-center p-4">No room types have been added for this hotel yet.</div>'; endif; ?>
            </div>
        </div>
    </div>
</div>
<?php include 'footer.php'; ?>
