<?php 
require_once 'includes/db.php';
$message = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = trim($_POST['full_name']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $partner_type = $_POST['partner_type']; // 'tour_partner' or 'hotel_partner'

    if (!in_array($partner_type, ['tour_partner', 'hotel_partner'])) {
        $message = '<div class="alert alert-danger">Please select a valid partner type.</div>';
    } elseif (strlen($password) < 8) {
        $message = '<div class="alert alert-danger">Password must be at least 8 characters long.</div>';
    } else {
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE email = ?");
        $stmt_check->bind_param("s", $email);
        $stmt_check->execute();
        if ($stmt_check->get_result()->num_rows > 0) {
            $message = '<div class="alert alert-danger">An account with this email already exists.</div>';
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt_insert = $conn->prepare("INSERT INTO users (full_name, email, password, role, status) VALUES (?, ?, ?, ?, 'pending')");
            $stmt_insert->bind_param("ssss", $full_name, $email, $hashed_password, $partner_type);
            if ($stmt_insert->execute()) {
                $message = '<div class="alert alert-success">Thank you for registering! Your application is pending review.</div>';
            } else {
                $message = '<div class="alert alert-danger">Registration failed. Please try again.</div>';
            }
        }
    }
}
include 'includes/header.php'; 
?>
<main class="container my-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-lg"><div class="card-body p-5">
                <h2 class="text-center mb-4">Become a Partner</h2>
                <p class="text-center text-muted mb-4">Register to list your properties on our platform.</p>
                <?php echo $message; ?>
                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">I am a...</label>
                        <select name="partner_type" class="form-select" required>
                            <option value="tour_partner">Tour Operator / Manager</option>
                            <option value="hotel_partner">Hotel Owner / Manager</option>
                        </select>
                    </div>
                    <div class="mb-3"><label class="form-label">Full Name or Business Name</label><input type="text" class="form-control" name="full_name" required></div>
                    <div class="mb-3"><label class="form-label">Business Email</label><input type="email" class="form-control" name="email" required></div>
                    <div class="mb-3"><label class="form-label">Password</label><input type="password" class="form-control" name="password" minlength="8" required></div>
                    <div class="d-grid"><button type="submit" class="btn btn-primary">Submit Application</button></div>
                </form>
            </div></div>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
