<?php 
require_once 'db.php';

// Fetch all site settings into a global associative array for use on all pages
$settings_result = $conn->query("SELECT * FROM site_settings");
$site_settings = [];
if ($settings_result) {
    while ($row = $settings_result->fetch_assoc()) {
        $site_settings[$row['setting_name']] = $row['setting_value'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta name="description" content="<?php echo htmlspecialchars($site_settings['seo_meta_description'] ?? 'Your premier booking portal for tours, hotels, and flights in the Philippines.'); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($site_settings['seo_meta_keywords'] ?? 'philippines travel, book tours, book hotels'); ?>">
    
    <title><?php echo htmlspecialchars($site_settings['site_name'] ?? 'DXP Travel & Tours'); ?></title>

    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png?v=1">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png?v=1">
    
    <style>
      :root {
        --primary-color: <?php echo htmlspecialchars($site_settings['theme_primary_color'] ?? '#0d6efd'); ?>;
        --secondary-color: <?php echo htmlspecialchars($site_settings['theme_secondary_color'] ?? '#6c757d'); ?>;
        --success-color: <?php echo htmlspecialchars($site_settings['theme_success_color'] ?? '#198754'); ?>;
        --dark-color: <?php echo htmlspecialchars($site_settings['theme_dark_color'] ?? '#212529'); ?>;
        --light-color: <?php echo htmlspecialchars($site_settings['theme_light_color'] ?? '#f8f9fa'); ?>;
      }
    </style>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="/css/style.css">
    
    <?php echo $site_settings['header_scripts'] ?? ''; ?>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark sticky-top shadow-sm">
  <div class="container">
    <a class="navbar-brand d-flex align-items-center" href="index.php" title="<?php echo htmlspecialchars($site_settings['site_name'] ?? ''); ?>">
        <?php if (!empty($site_settings['site_logo_url'])): ?>
            <img src="<?php echo htmlspecialchars($site_settings['site_logo_url']); ?>" alt="<?php echo htmlspecialchars($site_settings['site_name']); ?> Logo" style="max-height: 40px;">
        <?php else: ?>
            <i class="bi bi-compass-fill fs-4"></i> <?php endif; ?>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto align-items-center">
        <li class="nav-item"><a class="nav-link" href="index.php">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="services.php">Tours & Services</a></li>
        <li class="nav-item"><a class="nav-link" href="destinations.php">Destinations</a></li>
        <li class="nav-item"><a class="nav-link" href="hotels.php">Hotels</a></li>
        <li class="nav-item"><a class="nav-link" href="flights.php">Flights</a></li>
        <li class="nav-item"><a class="nav-link" href="ferries.php">Ferries</a></li>
        <li class="nav-item"><a class="nav-link" href="articles.php">Blog</a></li>
        <li class="nav-item"><a class="nav-link" href="faq.php">FAQ</a></li>
        <li class="nav-item"><a class="nav-link" href="contact.php">Contact</a></li>
        <li class="nav-item ms-lg-2">
        <?php if (isset($_SESSION['user_id'])): ?>
            <div class="dropdown">
              <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="bi bi-person-circle me-1"></i> <?php echo htmlspecialchars($_SESSION['user_name']); ?></a>
              <ul class="dropdown-menu dropdown-menu-end">
                <li><a class="dropdown-item" href="dashboard/"><i class="bi bi-grid-1x2-fill me-2"></i> My Dashboard</a></li>
                <li><a class="dropdown-item" href="dashboard/edit-profile.php"><i class="bi bi-person-fill-gear me-2"></i> Edit Profile</a></li>
                <li><a class="dropdown-item" href="dashboard/transactions.php"><i class="bi bi-clock-history me-2"></i> Transactions</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
              </ul>
            </div>
        <?php else: ?>
            <div class="d-flex gap-2"><a class="btn btn-outline-light btn-sm" href="login.php">Login</a><a class="btn btn-primary btn-sm" href="register.php">Register</a></div>
        <?php endif; ?>
        </li>
      </ul>
    </div>
  </div>
</nav>
