<?php 
include 'includes/header.php';

// --- SEARCH LOGIC ---
$search_location = trim($_GET['location'] ?? '');
$sql = "SELECT * FROM hotels";
$params = [];
$param_types = '';

if (!empty($search_location)) {
    $sql .= " WHERE location LIKE ?";
    $like_term = "%" . $search_location . "%";
    $params[] = $like_term;
    $param_types = 's';
}
$sql .= " ORDER BY name ASC";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($param_types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<main class="container mt-5">
    <div class="text-center mb-5">
        <?php if (!empty($search_location)): ?>
            <h1 class="display-4">Hotels in "<?php echo htmlspecialchars($search_location); ?>"</h1>
            <p class="lead">Showing <?php echo $result->num_rows; ?> results for your search. <a href="hotels.php">View all hotels.</a></p>
        <?php else: ?>
            <h1 class="display-4">Our Partner Hotels</h1>
            <p class="lead">Find the perfect stay for your next adventure.</p>
        <?php endif; ?>
    </div>

    <div class="row">
        <?php if ($result->num_rows > 0): while($hotel = $result->fetch_assoc()): ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100 tour-card">
                    <img src="<?php echo htmlspecialchars($hotel['main_image_url'] ?? 'https://via.placeholder.com/400x300.png?text=Hotel+Image'); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($hotel['name']); ?>">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title"><?php echo htmlspecialchars($hotel['name']); ?></h5>
                        <p class="card-text"><i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($hotel['location']); ?></p>
                        <div class="text-warning mb-2"><?php for($i=0; $i<$hotel['star_rating']; $i++) echo '<i class="bi bi-star-fill"></i>'; ?></div>
                        <p class="card-text flex-grow-1"><?php echo substr(htmlspecialchars($hotel['description']), 0, 100); ?>...</p>
                        <a href="hotel-details.php?id=<?php echo $hotel['id']; ?>" class="btn btn-primary mt-auto">View Rooms & Details</a>
                    </div>
                </div>
            </div>
        <?php endwhile; else: ?>
            <p class='text-center'>No hotels found matching your criteria.</p>
        <?php endif; ?>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
