<?php 
include 'includes/header.php'; 
$destinations_result = $conn->query("SELECT * FROM destinations ORDER BY name ASC");
?>
<div class="container my-5">
    <div class="text-center mb-5">
        <h1 class="display-4">Destination Guides</h1>
        <p class="lead">Explore the Philippines with our in-depth guides, curated by travel experts.</p>
    </div>
    <div class="row">
        <?php if ($destinations_result && $destinations_result->num_rows > 0): ?>
            <?php while($dest = $destinations_result->fetch_assoc()): ?>
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card h-100 tour-card shadow-sm">
                    <a href="destination-details.php?id=<?php echo $dest['id']; ?>">
                        <img src="<?php echo htmlspecialchars($dest['hero_image_url']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($dest['name']); ?>">
                    </a>
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title"><?php echo htmlspecialchars($dest['name']); ?></h5>
                        <p class="card-text flex-grow-1"><?php echo htmlspecialchars($dest['short_description']); ?></p>
                        <a href="destination-details.php?id=<?php echo $dest['id']; ?>" class="btn btn-primary mt-auto">Explore Guide</a>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        <?php else: ?>
            <p class="text-center">No destination guides have been published yet.</p>
        <?php endif; ?>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
