<?php
// --- LOGIC BLOCK ---
require_once 'includes/db.php';
require_once 'includes/email-sender.php';

// Fetch all site settings for display
$settings_result = $conn->query("SELECT * FROM site_settings");
$settings = [];
if ($settings_result) {
    while ($row = $settings_result->fetch_assoc()) {
        $settings[$row['setting_name']] = $row['setting_value'];
    }
}

$message_status = '';
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['contact_form'])) {
    $name = strip_tags(trim($_POST['name']));
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $subject = strip_tags(trim($_POST['subject']));
    $message = strip_tags(trim($_POST['message']));

    // Validation
    if (empty($name) || !filter_var($email, FILTER_VALIDATE_EMAIL) || empty($subject) || empty($message)) {
        $message_status = '<div class="alert alert-danger">Please fill in all fields correctly.</div>';
    } else {
        // 1. Save message to the database
        $stmt = $conn->prepare("INSERT INTO contact_messages (name, email, subject, message) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $name, $email, $subject, $message);
        
        if ($stmt->execute()) {
             $message_status = '<div class="alert alert-success">Thank you for your message! We will get back to you shortly.</div>';
             // 2. Send email notification to admin
             $email_subject = "New Contact Form Message: " . $subject;
             $email_body = "You have received a new message from <strong>" . htmlspecialchars($name) . "</strong> (" . htmlspecialchars($email) . ").<br><br><strong>Message:</strong><br>" . nl2br(htmlspecialchars($message)) . "<br><br>You can view this message in your admin panel.";
             sendAdminNotification($conn, $email_subject, $email_body);
        } else {
            $message_status = '<div class="alert alert-danger">Sorry, there was an error saving your message. Please try again later.</div>';
        }
    }
}

// --- PRESENTATION BLOCK ---
include 'includes/header.php'; 
?>

<main class="container my-5">
    <div class="text-center mb-5">
        <h1 class="display-4">Get In Touch</h1>
        <p class="lead">We'd love to hear from you. Whether you have a question about our tours, pricing, or anything else, our team is ready to answer all your questions.</p>
    </div>

    <div class="row g-4">
        <div class="col-lg-7">
            <div class="card p-4 shadow-sm h-100">
                <h3 class="mb-3"><i class="bi bi-pencil-square me-2"></i>Send us a Message</h3>
                <?php echo $message_status; ?>
                <form action="contact.php" method="POST" novalidate>
                    <input type="hidden" name="contact_form" value="1">
                    <div class="mb-3">
                        <label for="name" class="form-label">Full Name</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label for="subject" class="form-label">Subject</label>
                        <input type="text" class="form-control" id="subject" name="subject" required>
                    </div>
                    <div class="mb-3">
                        <label for="message" class="form-label">Message</label>
                        <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Submit Message</button>
                </form>
            </div>
        </div>
        <div class="col-lg-5">
             <div class="card p-4 shadow-sm h-100">
                <h3 class="mb-3"><i class="bi bi-person-rolodex me-2"></i>Contact Information</h3>
                <p><i class="bi bi-geo-alt-fill me-2"></i> <strong>Address:</strong><br><?php echo htmlspecialchars($settings['contact_address'] ?? 'Not set'); ?></p>
                <p><i class="bi bi-telephone-fill me-2"></i> <strong>Phone:</strong><br><a href="tel:<?php echo htmlspecialchars($settings['contact_phone'] ?? ''); ?>"><?php echo htmlspecialchars($settings['contact_phone'] ?? 'Not set'); ?></a></p>
                <p><i class="bi bi-envelope-fill me-2"></i> <strong>Email:</strong><br><a href="mailto:<?php echo htmlspecialchars($settings['contact_email'] ?? ''); ?>"><?php echo htmlspecialchars($settings['contact_email'] ?? 'Not set'); ?></a></p>
            </div>
        </div>
    </div>
    
    <div class="mt-5">
         <h3 class="text-center mb-4">Our Location</h3>
         <div class="card shadow-sm">
            <?php echo $settings['google_maps_iframe'] ?? '<p class="p-5 text-center text-muted">Map is not configured.</p>'; ?>
         </div>
    </div>
</main>

<?php include 'includes/footer.php'; ?>
