<?php
// --- LOGIC BLOCK ---
require_once '../includes/db.php';
require_once '../includes/partner-email-sender.php';

if (!isset($_SESSION['admin_logged_in'])) { header("Location: ../login.php"); exit; }

$partner_id = intval($_GET['partner_id'] ?? 0);
if ($partner_id <= 0) { header("Location: manage-users.php"); exit(); }

$message = '';
// ACTION: APPROVE/REJECT A DOCUMENT
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['doc_id'])) {
    $doc_id = intval($_POST['doc_id']);
    $new_status = $_POST['action'];
    $admin_notes = trim($_POST['admin_notes']);

    if (in_array($new_status, ['Approved', 'Rejected'])) {
        $stmt = $conn->prepare("UPDATE partner_documents SET status = ?, admin_notes = ? WHERE id = ?");
        $stmt->bind_param("ssi", $new_status, $admin_notes, $doc_id);
        if ($stmt->execute()) {
            $message = '<div class="alert alert-success">Document status updated successfully.</div>';
            // Send notification to partner
            $email_subject = "Update on your submitted document";
            $email_body = "An administrator has reviewed one of your documents.<br><br><strong>Status:</strong> " . $new_status . "<br><strong>Notes from Admin:</strong> " . htmlspecialchars($admin_notes) . "<br><br>Please log in to your dashboard to view the details.";
            sendPartnerNotification($conn, $partner_id, $email_subject, $email_body);
        }
    }
}

// Fetch partner and document details
$partner_stmt = $conn->prepare("SELECT full_name FROM users WHERE id = ? AND role LIKE '%_partner'");
$partner_stmt->bind_param("i", $partner_id);
$partner_stmt->execute();
$partner = $partner_stmt->get_result()->fetch_assoc();
if (!$partner) { header("Location: manage-users.php"); exit(); }

$docs_result = $conn->query("SELECT * FROM partner_documents WHERE partner_id = $partner_id ORDER BY upload_date DESC");

// --- PRESENTATION BLOCK ---
include 'admin-header.php';
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Review Documents for: <span class="text-primary"><?php echo htmlspecialchars($partner['full_name']); ?></span></h1>
    <a href="manage-users.php" class="btn btn-secondary">← Back to Users List</a>
</div>
<?php echo $message; ?>
<div class="card shadow-sm">
    <div class="card-header fw-bold">Submitted Documents</div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-dark">
                    <tr><th>Document Type</th><th class="text-center">File</th><th>Status</th><th>Action</th></tr>
                </thead>
                <tbody>
                <?php if ($docs_result && $docs_result->num_rows > 0): while($doc = $docs_result->fetch_assoc()): ?>
                    <tr>
                        <td><strong><?php echo htmlspecialchars($doc['document_type']); ?></strong><br><small class="text-muted">Uploaded: <?php echo date('M d, Y', strtotime($doc['upload_date'])); ?></small></td>
                        <td class="text-center"><a href="../<?php echo htmlspecialchars($doc['file_url']); ?>" target="_blank" class="btn btn-sm btn-outline-primary">View Document</a></td>
                        <td><span class="badge bg-<?php if($doc['status']=='Approved') echo 'success'; elseif($doc['status']=='Rejected') echo 'danger'; else echo 'warning text-dark'; ?>"><?php echo $doc['status']; ?></span></td>
                        <td style="min-width: 280px;">
                            <?php if($doc['status'] == 'Submitted'): ?>
                            <form method="POST">
                                <input type="hidden" name="doc_id" value="<?php echo $doc['id']; ?>">
                                <div class="input-group input-group-sm">
                                    <input type="text" name="admin_notes" class="form-control" placeholder="Notes (for rejection)">
                                    <button type="submit" name="action" value="Approved" class="btn btn-success" title="Approve"><i class="bi bi-check-circle-fill"></i></button>
                                    <button type="submit" name="action" value="Rejected" class="btn btn-danger" title="Reject"><i class="bi bi-x-circle-fill"></i></button>
                                </div>
                            </form>
                            <?php else: ?>
                                <span class="text-muted fst-italic">Processed</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endwhile; else: ?>
                    <tr><td colspan="4" class="text-center text-muted p-4">This partner has not submitted any documents yet.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include 'admin-footer.php'; ?>
