<?php
include 'admin-header.php';

$message = '';
// --- ACTION HANDLING ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['withdrawal_id'])) {
    $withdrawal_id = intval($_POST['withdrawal_id']);
    $admin_notes = trim($_POST['admin_notes']);

    if (isset($_POST['mark_completed'])) {
        $stmt = $conn->prepare("UPDATE withdrawals SET status = 'Completed', admin_notes = ?, processed_at = NOW() WHERE id = ? AND status = 'Pending'");
        $stmt->bind_param("si", $admin_notes, $withdrawal_id);
        if ($stmt->execute() && $stmt->affected_rows > 0) {
            $message = '<div class="alert alert-success">Withdrawal marked as completed.</div>';
        } else {
            $message = '<div class="alert alert-warning">Could not process request. It might have been already processed.</div>';
        }
    } elseif (isset($_POST['mark_rejected'])) {
        $stmt = $conn->prepare("UPDATE withdrawals SET status = 'Rejected', admin_notes = ? WHERE id = ? AND status = 'Pending'");
        $stmt->bind_param("si", $admin_notes, $withdrawal_id);
        if ($stmt->execute() && $stmt->affected_rows > 0) {
            $message = '<div class="alert alert-danger">Withdrawal has been rejected.</div>';
        } else {
            $message = '<div class="alert alert-warning">Could not process request. It might have been already processed.</div>';
        }
    }
}

// Fetch pending withdrawal requests
$pending_withdrawals = $conn->query("
    SELECT w.*, u.full_name, u.email, u.payout_details 
    FROM withdrawals w
    JOIN users u ON w.partner_id = u.id
    WHERE w.status = 'Pending'
    ORDER BY w.created_at ASC
");
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage Withdrawal Requests</h1>
</div>
<?php echo $message; ?>

<div class="card shadow-sm">
    <div class="card-header fw-bold">Pending Payouts</div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Partner</th>
                        <th>Amount</th>
                        <th>Payout Details</th>
                        <th>Requested On</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php if ($pending_withdrawals && $pending_withdrawals->num_rows > 0): ?>
                    <?php while($row = $pending_withdrawals->fetch_assoc()): ?>
                    <tr>
                        <td><strong><?php echo htmlspecialchars($row['full_name']); ?></strong><br><small class="text-muted"><?php echo htmlspecialchars($row['email']); ?></small></td>
                        <td class="fw-bold fs-5 text-danger">- ₱<?php echo number_format($row['amount'], 2); ?></td>
                        <td><pre style="white-space: pre-wrap; font-size: 0.9em;"><?php echo htmlspecialchars($row['payout_details']); ?></pre></td>
                        <td><?php echo date('M d, Y H:i A', strtotime($row['created_at'])); ?></td>
                        <td style="min-width: 250px;">
                            <form method="POST">
                                <input type="hidden" name="withdrawal_id" value="<?php echo $row['id']; ?>">
                                <div class="input-group input-group-sm">
                                    <input type="text" name="admin_notes" class="form-control" placeholder="Note / Transaction ID">
                                    <button type="submit" name="mark_completed" class="btn btn-success" title="Mark as Completed"><i class="bi bi-check-circle-fill"></i></button>
                                    <button type="submit" name="mark_rejected" class="btn btn-danger" title="Reject Request"><i class="bi bi-x-circle-fill"></i></button>
                                </div>
                            </form>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="5" class="text-center text-muted p-4">No pending withdrawal requests.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'admin-footer.php'; ?>
