<?php
include 'admin-header.php';

$message = '';
// Handle Delete Action
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_article'])) {
    $article_id_to_delete = intval($_POST['article_id']);

    // First, delete the associated image file
    $stmt_img = $conn->prepare("SELECT image_url FROM articles WHERE id = ?");
    $stmt_img->bind_param("i", $article_id_to_delete);
    $stmt_img->execute();
    $result_img = $stmt_img->get_result();
    if($row_img = $result_img->fetch_assoc()) {
        if(!empty($row_img['image_url']) && file_exists('../' . $row_img['image_url'])) {
            unlink('../' . $row_img['image_url']);
        }
    }
    
    // Then, delete the article from the database
    $stmt_del = $conn->prepare("DELETE FROM articles WHERE id = ?");
    $stmt_del->bind_param("i", $article_id_to_delete);
    if ($stmt_del->execute()) {
        $message = '<div class="alert alert-success">Article deleted successfully.</div>';
    } else {
        $message = '<div class="alert alert-danger">Error deleting article.</div>';
    }
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage Articles</h1>
    <a href="edit-article.php" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Article
    </a>
</div>
<?php echo $message; ?>

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Author</th>
                        <th>Publish Date</th>
                        <th class="text-center">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $result = $conn->query("SELECT * FROM articles ORDER BY publish_date DESC");
                    while($article = $result->fetch_assoc()):
                    ?>
                    <tr>
                        <td><img src="../<?php echo htmlspecialchars($article['image_url']); ?>" alt="Article Image" style="width: 100px; height: 60px; object-fit: cover;" class="img-thumbnail"></td>
                        <td><strong><?php echo htmlspecialchars($article['title']); ?></strong></td>
                        <td><?php echo htmlspecialchars($article['author']); ?></td>
                        <td><?php echo date('F d, Y', strtotime($article['publish_date'])); ?></td>
                        <td class="text-center">
                            <a href="edit-article.php?id=<?php echo $article['id']; ?>" class="btn btn-primary btn-sm">Edit</a>
                            <form method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this article?');">
                                <input type="hidden" name="article_id" value="<?php echo $article['id']; ?>">
                                <button type="submit" name="delete_article" class="btn btn-danger btn-sm">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'admin-footer.php'; ?>
