<?php
include 'admin-header.php';
$message = '';
// ACTION HANDLING
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['delete_airport'])) {
        $id = intval($_POST['id']);
        $stmt = $conn->prepare("DELETE FROM airports WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $message = '<div class="alert alert-success">Airport deleted successfully.</div>';
    } elseif (isset($_POST['save_airport'])) {
        $id = intval($_POST['id'] ?? 0);
        $name = trim($_POST['airport_name']);
        $code = trim($_POST['airport_code']);
        $city = trim($_POST['city']);
        if ($id > 0) {
            $stmt = $conn->prepare("UPDATE airports SET airport_name=?, airport_code=?, city=? WHERE id=?");
            $stmt->bind_param("sssi", $name, $code, $city, $id);
            $message = '<div class="alert alert-success">Airport updated.</div>';
        } else {
            $stmt = $conn->prepare("INSERT INTO airports (airport_name, airport_code, city) VALUES (?, ?, ?)");
            $stmt->bind_param("sss", $name, $code, $city);
            $message = '<div class="alert alert-success">New airport added.</div>';
        }
        $stmt->execute();
    }
}
$edit_airport = null;
if (isset($_GET['edit'])) {
    $stmt = $conn->prepare("SELECT * FROM airports WHERE id = ?");
    $stmt->bind_param("i", $_GET['edit']);
    $stmt->execute();
    $edit_airport = $stmt->get_result()->fetch_assoc();
}
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage Airports</h1>
</div>
<?php echo $message; ?>
<div class="card shadow-sm mb-4">
    <div class="card-header"><?php echo $edit_airport ? 'Edit Airport' : 'Add New Airport'; ?></div>
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="id" value="<?php echo $edit_airport['id'] ?? 0; ?>">
            <div class="row">
                <div class="col-md-5"><label>Airport Name</label><input type="text" name="airport_name" class="form-control" value="<?php echo htmlspecialchars($edit_airport['airport_name'] ?? ''); ?>" required></div>
                <div class="col-md-3"><label>Airport Code (3 Letters)</label><input type="text" name="airport_code" class="form-control" value="<?php echo htmlspecialchars($edit_airport['airport_code'] ?? ''); ?>" required></div>
                <div class="col-md-4"><label>City</label><input type="text" name="city" class="form-control" value="<?php echo htmlspecialchars($edit_airport['city'] ?? ''); ?>" required></div>
            </div>
            <button type="submit" name="save_airport" class="btn btn-primary mt-3"><?php echo $edit_airport ? 'Save Changes' : 'Add Airport'; ?></button>
        </form>
    </div>
</div>
<div class="card shadow-sm"><div class="card-header">Existing Airports</div><div class="table-responsive">
    <table class="table table-hover">
        <thead><tr><th>Name</th><th>Code</th><th>City</th><th>Actions</th></tr></thead>
        <tbody>
        <?php $result = $conn->query("SELECT * FROM airports ORDER BY city ASC"); while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['airport_name']); ?></td>
                <td><?php echo htmlspecialchars($row['airport_code']); ?></td>
                <td><?php echo htmlspecialchars($row['city']); ?></td>
                <td><a href="?edit=<?php echo $row['id']; ?>" class="btn btn-sm btn-primary">Edit</a></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div></div>
<?php include 'admin-footer.php'; ?>
