<?php
require_once '../includes/db.php';

// Security check to ensure an admin is logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true || !isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit;
}

// Fetch the full, current admin user data on every page load
$admin_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ? AND role = 'admin'");
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$admin_user = $stmt->get_result()->fetch_assoc();
if (!$admin_user) { session_destroy(); header("Location: ../login.php"); exit(); }
$admin_name = $admin_user['full_name'];

// Fetch site settings
$settings_result = $conn->query("SELECT * FROM site_settings");
$site_settings = [];
if ($settings_result) { while ($row = $settings_result->fetch_assoc()) { $site_settings[$row['setting_name']] = $row['setting_value']; } }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo htmlspecialchars($site_settings['site_name'] ?? 'DXP Tours'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="/css/style.css">
</head>
<body>
<nav class="navbar navbar-dark bg-dark sticky-top d-flex flex-md-nowrap p-0 shadow">
    <a class="navbar-brand col-md-3 col-lg-2 me-0 px-3 fs-6" href="dashboard.php"><i class="bi bi-compass-fill"></i> DXP Admin</a>
    <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar"></button>
    <div class="dropdown ms-auto me-3">
        <a href="#" class="d-flex align-items-center text-white text-decoration-none dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-person-circle me-2"></i><strong><?php echo htmlspecialchars($admin_name); ?></strong>
        </a>
        <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end text-small shadow">
            <li><a class="dropdown-item" href="edit-profile.php"><i class="bi bi-person-fill-gear me-2"></i> Edit My Profile</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Log Out</a></li>
        </ul>
    </div>
</nav>
<div class="container-fluid">
    <div class="row">
        <nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-dark sidebar collapse admin-sidebar vh-100">
            <div class="d-flex flex-column h-100 pt-3">
                <ul class="nav flex-column">
                    <li class="nav-item"><a class="nav-link text-white" href="dashboard.php"><i class="bi bi-grid-1x2-fill me-2"></i> Dashboard</a></li>
                    <li class="nav-item mt-2"><a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#bookingsMenu"><span><i class="bi bi-briefcase-fill me-2"></i> Bookings & Inquiries</span><i class="bi bi-chevron-down small"></i></a><div class="collapse" id="bookingsMenu"><ul class="nav flex-column ps-4"><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-messages.php">Contact Messages</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="ferry-bookings.php">Ferry Bookings</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="flight-bookings.php">Flight Bookings</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="hotel-bookings.php">Hotel Bookings</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-bookings.php">Tour Bookings</a></li></ul></div></li>
                    <li class="nav-item mt-2"><a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#usersMenu"><span><i class="bi bi-people-fill me-2"></i> Users & Financials</span><i class="bi bi-chevron-down small"></i></a><div class="collapse" id="usersMenu"><ul class="nav flex-column ps-4"><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-users.php">Manage Users</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-affiliates.php">Manage Affiliates</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="review-documents.php">Review Documents</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-withdrawals.php">Withdrawal Requests</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="top-up-requests.php">Top-Up Requests</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="transactions.php">Transaction History</a></li></ul></div></li>
                    <li class="nav-item mt-2"><a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#contentMenu"><span><i class="bi bi-pencil-square me-2"></i> Manage Content</span><i class="bi bi-chevron-down small"></i></a><div class="collapse" id="contentMenu"><ul class="nav flex-column ps-4"><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-airports.php">Airports</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-articles.php">Articles</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-comments.php">Comments</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-destinations.php">Destinations</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-faqs.php">FAQs</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-ferry-routes.php">Ferry Routes</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-hotels.php">Hotels</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-pages.php">Page Editor</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-reviews.php">Reviews</a></li><li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-tours.php">Tours & Services</a></li></ul></div></li>
                </ul>
                <ul class="nav flex-column mt-auto mb-2">
                     <li class="nav-item"><a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#settingsMenu"><span><i class="bi bi-gear-fill me-2"></i> Settings</span><i class="bi bi-chevron-down small"></i></a><div class="collapse" id="settingsMenu"><ul class="nav flex-column ps-4">
                        <li class="nav-item"><a class="nav-link text-white-50 py-1" href="site-settings.php">Site Settings</a></li>
                        <li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-theme.php">Theme Editor</a></li>
                        <li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-tickets.php">Ticket Editor</a></li>
                        <li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-payment-methods.php">Payment Methods</a></li>
                        <li class="nav-item"><a class="nav-link text-white-50 py-1" href="manage-admins.php">Manage Admins</a></li>
                     </ul></div></li>
                    <li class="nav-item"><a class="nav-link text-danger" href="../logout.php"><i class="bi bi-box-arrow-right me-2"></i> Log Out</a></li>
                </ul>
            </div>
        </nav>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
