<?php 
// 1. INCLUDE HEADER & HELPERS
include 'includes/header.php'; 
require_once 'includes/helpers.php'; 

// 2. PAGINATION & DATA FETCHING
$records_per_page = 9; // A 3x3 grid
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $records_per_page;

// Count total published articles for pagination
$count_result = $conn->query("SELECT COUNT(id) as total FROM articles WHERE is_published = 1");
$total_records = $count_result->fetch_assoc()['total'];
$total_pages = ceil($total_records / $records_per_page);

// Fetch the articles for the current page
$stmt = $conn->prepare("SELECT * FROM articles WHERE is_published = 1 ORDER BY publish_date DESC LIMIT ? OFFSET ?");
$stmt->bind_param("ii", $records_per_page, $offset);
$stmt->execute();
$articles_result = $stmt->get_result();
$articles = $articles_result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<div class="container my-4">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Blog</li>
        </ol>
    </nav>
    <h1 class="display-5">Travel Guides & Articles</h1>
    <p class="lead text-muted">Tips, guides, and stories to inspire your next journey.</p>
</div>

<div class="container mb-5">
    <?php if (!empty($articles)): ?>
    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
        <?php foreach ($articles as $article): ?>
        <div class="col">
            <div class="card h-100 tour-card shadow-sm">
                <a href="article-details.php?id=<?php echo $article['id']; ?>">
                    <img src="<?php echo htmlspecialchars($article['image_url']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($article['title']); ?>">
                </a>
                <div class="card-body d-flex flex-column">
                    <h5 class="card-title">
                        <a href="article-details.php?id=<?php echo $article['id']; ?>" class="text-dark text-decoration-none">
                            <?php echo htmlspecialchars($article['title']); ?>
                        </a>
                    </h5>
                    <p class="card-text flex-grow-1 text-muted small">
                        <?php echo substr(strip_tags($article['content']), 0, 100); ?>...
                    </p>
                    <a href="article-details.php?id=<?php echo $article['id']; ?>" class="btn btn-primary mt-auto">Read More</a>
                </div>
                <div class="card-footer d-flex justify-content-between align-items-center small text-muted">
                    <span><?php echo date('F j, Y', strtotime($article['publish_date'])); ?></span>
                    <div class="d-flex gap-3">
                        <span title="Views"><i class="bi bi-eye-fill"></i> <?php echo $article['view_count'] ?? 0; ?></span>
                        <span title="Likes"><i class="bi bi-heart-fill"></i> <?php echo $article['like_count'] ?? 0; ?></span>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php else: ?>
        <div class="text-center p-5 border rounded">
            <h3 class="text-muted">No Articles Found</h3>
            <p>There are no blog articles to display at the moment. Please check back later!</p>
        </div>
    <?php endif; ?>
    
    <?php if($total_pages > 1): ?>
    <nav class="mt-5" aria-label="Blog pagination">
        <ul class="pagination justify-content-center">
            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>">
                    <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                </li>
            <?php endfor; ?>
        </ul>
    </nav>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
