<?php 
include 'includes/header.php'; 
require_once 'includes/rss-parser.php';

// Define the official RSS feeds
$pna_travel_feed_url = 'https://www.pna.gov.ph/feed/latest'; // Philippine News Agency
$pagasa_feed_url = 'https://www.pagasa.dost.gov.ph/rss/pws.xml';   // PAGASA Weather Advisories

// Fetch the latest items from each feed
$travel_news = fetch_rss_feed($pna_travel_feed_url, 5);
$weather_advisories = fetch_rss_feed($pagasa_feed_url, 3);
?>
<main class="container my-5">
    <div class="text-center mb-5">
        <h1 class="display-4">Travel Advisories & News</h1>
        <p class="lead">Stay updated with the latest official travel news and weather alerts for the Philippines.</p>
    </div>

    <div class="row g-5">
        <div class="col-lg-8">
            <h3 class="pb-3 mb-4 fst-italic border-bottom"><i class="bi bi-newspaper me-2"></i>Latest Travel News (from PNA)</h3>
            <?php if (!empty($travel_news)): foreach ($travel_news as $item): ?>
            <article class="blog-post mb-4">
                <h4 class="blog-post-title"><?php echo htmlspecialchars($item['title']); ?></h4>
                <p class="blog-post-meta"><?php echo date('F j, Y', strtotime($item['date'])); ?></p>
                <p><?php echo htmlspecialchars(strip_tags($item['desc'])); ?></p>
                <a href="<?php echo htmlspecialchars($item['link']); ?>" target="_blank" class="stretched-link">Read full story...</a>
            </article>
            <?php endforeach; else: ?>
            <p>Could not load travel news at this time.</p>
            <?php endif; ?>
        </div>

        <div class="col-lg-4">
            <div class="position-sticky" style="top: 80px;">
                <div class="p-4 mb-3 bg-light rounded">
                    <h4 class="fst-italic"><i class="bi bi-cloud-sun-fill me-2"></i>PAGASA Weather Alerts</h4>
                    <ul class="list-unstyled mb-0">
                    <?php if (!empty($weather_advisories)): foreach ($weather_advisories as $item): ?>
                        <li class="border-bottom py-2">
                            <a href="<?php echo htmlspecialchars($item['link']); ?>" class="text-decoration-none text-dark" target="_blank">
                                <?php echo htmlspecialchars($item['title']); ?>
                            </a>
                        </li>
                    <?php endforeach; else: ?>
                        <li>Could not load weather advisories.</li>
                    <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
