<?php
require_once 'admin-header.php';

$partner_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$partner_id) { header("Location: review-documents.php"); exit(); }

// --- Handle Approve/Reject Actions ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'approve') {
        $conn->query("UPDATE users SET status = 'active', verification_status = 'verified', is_verified = 1 WHERE id = $partner_id");
        $conn->query("UPDATE partner_documents SET status = 'Approved', admin_notes = NULL WHERE partner_id = $partner_id");
        // You can add an email notification here to the partner
        $_SESSION['success_message'] = "Partner has been approved and activated.";
    } 
    elseif ($action === 'reject') {
        $reason = trim($_POST['reason']);
        $conn->query("UPDATE users SET verification_status = 'rejected' WHERE id = $partner_id");
        $stmt = $conn->prepare("UPDATE partner_documents SET status = 'Rejected', admin_notes = ? WHERE partner_id = ?");
        $stmt->bind_param("si", $reason, $partner_id);
        $stmt->execute();
        $stmt->close();
        // You can add an email notification here, including the reason
        $_SESSION['success_message'] = "Partner application has been rejected.";
    }
    header("Location: review-documents.php");
    exit();
}

// Fetch partner details and their documents
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ? AND role LIKE '%partner%'");
$stmt->bind_param("i", $partner_id);
$stmt->execute();
$partner = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$partner) { header("Location: review-documents.php"); exit(); }
$page_title = 'Reviewing: ' . htmlspecialchars($partner['business_name']);

$docs = $conn->query("SELECT * FROM partner_documents WHERE partner_id = $partner_id")->fetch_all(MYSQLI_ASSOC);
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><?php echo $page_title; ?></h1>
    <a href="review-documents.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back to List</a>
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header bg-light border-0"><h5>Partner Information</h5></div>
            <div class="card-body">
                <p><strong>Contact Person:</strong> <?php echo htmlspecialchars($partner['full_name']); ?></p>
                <p><strong>Business Name:</strong> <?php echo htmlspecialchars($partner['business_name']); ?></p>
                <p><strong>Email:</strong> <?php echo htmlspecialchars($partner['email']); ?></p>
            </div>
        </div>
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5>Submitted Documents</h5></div>
            <ul class="list-group list-group-flush">
                <?php foreach($docs as $doc): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <?php echo htmlspecialchars(ucfirst(str_replace('_', ' ', $doc['document_type']))); ?>
                    <a href="../<?php echo htmlspecialchars($doc['file_url']); ?>" class="btn btn-sm btn-outline-primary" target="_blank"><i class="bi bi-eye-fill"></i> View File</a>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5>Actions</h5></div>
            <div class="card-body text-center p-4">
                <p>Review the partner's information and documents, then approve or reject their application.</p>
                <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                    <form method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to APPROVE this partner?');"><input type="hidden" name="action" value="approve"><button type="submit" class="btn btn-success btn-lg">Approve Partner</button></form>
                    <button type="button" class="btn btn-danger btn-lg" data-bs-toggle="modal" data-bs-target="#rejectModal">Reject Partner</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="rejectModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header"><h5 class="modal-title">Reject Application</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
      <form method="POST">
          <div class="modal-body">
            <input type="hidden" name="action" value="reject">
            <div class="mb-3">
              <label for="reason" class="form-label">Reason for Rejection (will be shown to partner)</label>
              <textarea class="form-control" id="reason" name="reason" rows="3" required></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-danger">Confirm Rejection</button>
          </div>
      </form>
    </div>
  </div>
</div>

<?php require_once 'admin-footer.php'; ?>
