<?php
include '../includes/db.php'; // Your database connection file
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Basic validation
    if (isset($_POST['booking_id'], $_POST['passenger_name'], $_POST['seat_number'], $_POST['flight_number'])) {

        $booking_id = intval($_POST['booking_id']);
        $passenger_name = trim($_POST['passenger_name']);
        $seat_number = trim($_POST['seat_number']);
        $flight_number = trim($_POST['flight_number']);
        $gate = trim($_POST['gate']);
        $boarding_time = $_POST['boarding_time'];
        $departure_time = $_POST['departure_time'];
        $arrival_time = $_POST['arrival_time'];
        $status = $_POST['status'];

        // Prepare the update statement
        // This is a conceptual query and should be adapted to your database schema
        $stmt = $conn->prepare("UPDATE flight_bookings SET passenger_name = ?, seat_number = ?, flight_number = ?, gate = ?, boarding_time = ?, departure_time = ?, arrival_time = ?, status = ? WHERE id = ?");
        $stmt->bind_param("ssssssssi", $passenger_name, $seat_number, $flight_number, $gate, $boarding_time, $departure_time, $arrival_time, $status, $booking_id);

        if ($stmt->execute()) {
            $_SESSION['message'] = "Boarding pass details updated successfully.";
            $_SESSION['message_type'] = "success";
        } else {
            $_SESSION['message'] = "Error updating record: " . $stmt->error;
            $_SESSION['message_type'] = "danger";
        }
        $stmt->close();
    } else {
        $_SESSION['message'] = "All required fields must be filled.";
        $_SESSION['message_type'] = "danger";
    }

    // Redirect back to the bookings management page
    header("Location: manage-bookings.php");
    exit();
}
?>
