<?php
require_once 'admin-header.php'; 
$page_title = 'Review Partner Documents';

// Fetch all users with a 'partner' role who are awaiting document review
$stmt = $conn->prepare("
    SELECT id, full_name, business_name, email, created_at 
    FROM users 
    WHERE role LIKE '%partner%' AND verification_status = 'pending_review'
    ORDER BY created_at ASC
");
$stmt->execute();
$partners = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-file-earmark-check-fill me-2"></i>Review Partner Documents</h1>
</div>

<div class="card shadow-sm border-0">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Partner Name</th>
                        <th>Business Name</th>
                        <th>Email</th>
                        <th>Submitted On</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($partners)): ?>
                        <tr>
                            <td colspan="5" class="text-center p-5">
                                <i class="bi bi-check2-circle fs-2 text-muted"></i>
                                <p class="mt-2 mb-0 text-muted">No pending applications to review.</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($partners as $partner): ?>
                        <tr>
                            <td class="fw-bold"><?php echo htmlspecialchars($partner['full_name']); ?></td>
                            <td><?php echo htmlspecialchars($partner['business_name']); ?></td>
                            <td><?php echo htmlspecialchars($partner['email']); ?></td>
                            <td><?php echo date('F j, Y', strtotime($partner['created_at'])); ?></td>
                            <td class="text-end">
                                <a href="view-partner-application.php?id=<?php echo $partner['id']; ?>" class="btn btn-sm btn-primary">Review Application</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once 'admin-footer.php'; ?>
