<?php
require_once '../includes/db.php';
$token = $_GET["token"] ?? '';
$token_hash = hash("sha256", $token);

$stmt = $conn->prepare("SELECT * FROM admins WHERE reset_token_hash = ?");
$stmt->bind_param("s", $token_hash);
$stmt->execute();
$admin = $stmt->get_result()->fetch_assoc();
$stmt->close();

$is_token_valid = true;
if ($admin === null || strtotime($admin["reset_token_expires_at"]) <= time()) {
    $is_token_valid = false;
}

$errors = [];
if ($_SERVER["REQUEST_METHOD"] === "POST" && $is_token_valid) {
    $password = $_POST["password"];
    $password_confirm = $_POST["password_confirm"];

    if (strlen($password) < 8) { $errors[] = "Password must be at least 8 characters."; }
    if ($password !== $password_confirm) { $errors[] = "Passwords do not match."; }

    if (empty($errors)) {
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt_update = $conn->prepare("UPDATE admins SET password = ?, reset_token_hash = NULL, reset_token_expires_at = NULL WHERE id = ?");
        $stmt_update->bind_param("si", $password_hash, $admin["id"]);
        $stmt_update->execute();
        
        // Use a session flash message for the login page
        session_start();
        $_SESSION['success_message'] = "Password has been reset successfully. Please log in.";
        header("Location: index.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en" data-bs-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Set New Admin Password</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style> body { background-color: var(--bs-body-bg); } </style>
</head>
<body>
    <div class="container"><div class="row justify-content-center align-items-center vh-100"><div class="col-md-6 col-lg-4">
        <div class="text-center mb-4"><h1 class="h3">Set New Password</h1></div>
        <div class="card shadow-sm border-0"><div class="card-body p-4">
            <?php if (!$is_token_valid): ?>
                <div class="alert alert-danger">Invalid or expired link.</div>
                <div class="d-grid"><a href="forgot-password.php" class="btn btn-primary">Request a New Link</a></div>
            <?php else: ?>
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger"><?php foreach ($errors as $error): ?><p class="mb-0"><?php echo $error; ?></p><?php endforeach; ?></div>
                <?php endif; ?>
                <form method="POST">
                    <div class="mb-3"><label for="password" class="form-label">New Password</label><input type="password" class="form-control" id="password" name="password" required></div>
                    <div class="mb-3"><label for="password_confirm" class="form-label">Confirm New Password</label><input type="password" class="form-control" id="password_confirm" name="password_confirm" required></div>
                    <div class="d-grid"><button type="submit" class="btn btn-primary btn-lg">Reset Password</button></div>
                </form>
            <?php endif; ?>
        </div>
    </div></div></div>
</body>
</html>
