<?php
require_once 'admin-header.php'; 
$page_title = 'Edit My Profile';

// --- Handle Profile Picture Upload ---
function handle_admin_avatar_upload($file_input_name, $admin_id) {
    global $conn;
    if (isset($_FILES[$file_input_name]) && $_FILES[$file_input_name]['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES[$file_input_name];
        $upload_dir = '../uploads/avatars/';
        if (!is_dir($upload_dir)) { mkdir($upload_dir, 0755, true); }
        
        $filename = 'admin-' . $admin_id . '-' . time() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
        $target_path = $upload_dir . $filename;
        
        if (move_uploaded_file($file['tmp_name'], $target_path)) {
            $db_path = 'uploads/avatars/' . $filename;
            $stmt = $conn->prepare("UPDATE admins SET profile_image_url = ? WHERE id = ?");
            $stmt->bind_param("si", $db_path, $admin_id);
            $stmt->execute();
            $stmt->close();
            return true;
        }
    }
    return false;
}


// --- Handle Form Submissions ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $form_type = $_POST['_form_type'] ?? '';

    // Handle DETAILS update
    if ($form_type === 'update_details') {
        $full_name = trim($_POST['full_name']);
        $email = trim($_POST['email']);
        handle_admin_avatar_upload('profile_image', $admin_id);

        $stmt = $conn->prepare("UPDATE admins SET full_name = ?, email = ? WHERE id = ?");
        $stmt->bind_param("ssi", $full_name, $email, $admin_id);
        $stmt->execute();
        $stmt->close();
        
        $_SESSION['success_message'] = "Profile details updated successfully.";
    }

    // Handle PASSWORD update
    if ($form_type === 'change_password') {
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];

        if (password_verify($current_password, $admin_user['password'])) {
            if ($new_password === $confirm_password && strlen($new_password) >= 8) {
                $new_password_hash = password_hash($new_password, PASSWORD_DEFAULT);
                $stmt = $conn->prepare("UPDATE admins SET password = ? WHERE id = ?");
                $stmt->bind_param("si", $new_password_hash, $admin_id);
                $stmt->execute();
                $stmt->close();
                $_SESSION['success_message'] = "Password changed successfully.";
            } else {
                $_SESSION['error_message'] = "New passwords do not match or are too short.";
            }
        } else {
            $_SESSION['error_message'] = "Current password is incorrect.";
        }
    }

    header("Location: profile.php");
    exit();
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-person-fill-gear me-2"></i>Edit Profile</h1>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
<?php elseif (isset($_SESSION['error_message'])): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert"><?php echo $_SESSION['error_message']; unset($_SESSION['error_message']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
<?php endif; ?>


<div class="row">
    <div class="col-lg-7">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5 class="mb-0">Profile Details</h5></div>
            <div class="card-body">
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="_form_type" value="update_details">
                    <div class="mb-3">
                        <label for="full_name" class="form-label">Full Name</label>
                        <input type="text" class="form-control" id="full_name" name="full_name" value="<?php echo htmlspecialchars($admin_user['full_name']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="email" name="email" value="<?php echo htmlspecialchars($admin_user['email']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="profile_image" class="form-label">Profile Picture</label>
                        <input class="form-control" type="file" id="profile_image" name="profile_image" accept="image/*">
                        <?php if(!empty($admin_user['profile_image_url'])): ?>
                            <img src="../<?php echo htmlspecialchars($admin_user['profile_image_url']); ?>" class="img-thumbnail mt-2" width="100" alt="Current Profile Picture">
                        <?php endif; ?>
                    </div>
                    <button type="submit" class="btn btn-primary">Save Details</button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-5">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5 class="mb-0">Change Password</h5></div>
            <div class="card-body">
                <form method="POST">
                    <input type="hidden" name="_form_type" value="change_password">
                    <div class="mb-3">
                        <label for="current_password" class="form-label">Current Password</label>
                        <input type="password" class="form-control" id="current_password" name="current_password" required>
                    </div>
                    <div class="mb-3">
                        <label for="new_password" class="form-label">New Password</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" required>
                        <div class="form-text">Must be at least 8 characters long.</div>
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Confirm New Password</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Password</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'admin-footer.php'; ?>
