<?php
require_once 'admin-logic.php';

// Handle delete action
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete_item') {
    $item_id = filter_input(INPUT_POST, 'item_id', FILTER_VALIDATE_INT);
    if ($item_id) {
        $stmt = $conn->prepare("DELETE FROM pages WHERE id = ?");
        $stmt->bind_param("i", $item_id);
        if ($stmt->execute()) { $_SESSION['success_message'] = "Page deleted successfully."; } 
        else { $_SESSION['error_message'] = "Error deleting page."; }
        $stmt->close();
    }
    header("Location: manage-pages.php");
    exit();
}

// Fetch pages for display
$stmt = $conn->query("SELECT id, title, slug, is_published, updated_at FROM pages ORDER BY title ASC");
$pages = $stmt->fetch_all(MYSQLI_ASSOC);

$page_title = 'Manage Pages';
$current_page = 'manage-pages.php';
$active_category = 'contentMenu';

include 'admin-header.php';
?>

<?php if (isset($_SESSION['success_message'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
<?php endif; ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-file-earmark-text-fill me-2"></i><?php echo $page_title; ?></h1>
    <a href="edit-page.php" class="btn btn-primary"><i class="bi bi-plus-circle-fill me-1"></i> Add New Page</a>
</div>

<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead class="table-dark align-middle">
            <tr>
                <th>Page Title</th>
                <th>Slug (URL)</th>
                <th class="text-center">Status</th>
                <th>Last Updated</th>
                <th class="text-end">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($pages) > 0): foreach ($pages as $page): ?>
            <tr>
                <td class="fw-bold"><?php echo htmlspecialchars($page['title']); ?></td>
                <td>/<?php echo htmlspecialchars($page['slug']); ?></td>
                <td class="text-center">
                    <span class="badge bg-<?php echo ($page['is_published']) ? 'success' : 'secondary'; ?>">
                        <?php echo ($page['is_published']) ? 'Published' : 'Draft'; ?>
                    </span>
                </td>
                <td><?php echo date('F j, Y, g:i a', strtotime($page['updated_at'])); ?></td>
                <td class="text-end">
                    <div class="d-inline-flex gap-1">
                        <a href="../page.php?slug=<?php echo $page['slug']; ?>" class="btn btn-sm btn-outline-primary" title="View Live Page" target="_blank"><i class="bi bi-box-arrow-up-right"></i></a>
                        <a href="edit-page.php?id=<?php echo $page['id']; ?>" class="btn btn-sm btn-warning" title="Edit"><i class="bi bi-pencil-fill"></i></a>
                        <form method="POST" action="manage-pages.php" onsubmit="return confirm('Are you sure? This action cannot be undone.');">
                            <input type="hidden" name="action" value="delete_item">
                            <input type="hidden" name="item_id" value="<?php echo $page['id']; ?>">
                            <button type="submit" class="btn btn-sm btn-danger" title="Delete"><i class="bi bi-trash-fill"></i></button>
                        </form>
                    </div>
                </td>
            </tr>
            <?php endforeach; else: ?>
            <tr><td colspan="5" class="text-center p-4">No pages found. Click 'Add New Page' to create one.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include 'admin-footer.php'; ?>
