<?php
// STEP 1: Include the new all-in-one header.
require_once 'admin-header.php';

// STEP 2: Set the page-specific title.
$page_title = 'Admin Dashboard';

// --- QUERIES FOR DASHBOARD WIDGETS ---
$total_earnings_query = $conn->query("SELECT SUM(total_price) as total FROM hotel_bookings WHERE payment_status = 'Paid'");
$total_earnings = $total_earnings_query->fetch_assoc()['total'] ?? 0;
$total_users = $conn->query("SELECT COUNT(id) as total FROM users WHERE role = 'customer'")->fetch_assoc()['total'];
$pending_bookings = $conn->query("SELECT COUNT(id) as total FROM hotel_bookings WHERE status = 'Pending Confirmation'")->fetch_assoc()['total'];
$total_tours = $conn->query("SELECT COUNT(id) as total FROM tours")->fetch_assoc()['total'];
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Dashboard</h1>
</div>

<div class="row">
    <div class="col-xl-3 col-md-6 mb-4"><div class="card border-start-primary shadow h-100 py-2"><div class="card-body"><div class="row no-gutters align-items-center"><div class="col me-2"><div class="text-xs fw-bold text-primary text-uppercase mb-1">Total Earnings</div><div class="h5 mb-0 fw-bold text-gray-800"><?php echo format_price($total_earnings); ?></div></div><div class="col-auto"><i class="bi bi-cash-coin fs-2 text-black-50"></i></div></div></div></div></div>
    <div class="col-xl-3 col-md-6 mb-4"><div class="card border-start-success shadow h-100 py-2"><div class="card-body"><div class="row no-gutters align-items-center"><div class="col me-2"><div class="text-xs fw-bold text-success text-uppercase mb-1">Total Users</div><div class="h5 mb-0 fw-bold text-gray-800"><?php echo $total_users; ?></div></div><div class="col-auto"><i class="bi bi-people-fill fs-2 text-black-50"></i></div></div></div></div></div>
    <div class="col-xl-3 col-md-6 mb-4"><div class="card border-start-info shadow h-100 py-2"><div class="card-body"><div class="row no-gutters align-items-center"><div class="col me-2"><div class="text-xs fw-bold text-info text-uppercase mb-1">Listings</div><div class="h5 mb-0 mr-3 fw-bold text-gray-800"><?php echo $total_tours; ?></div></div><div class="col-auto"><i class="bi bi-compass-fill fs-2 text-black-50"></i></div></div></div></div></div>
    <div class="col-xl-3 col-md-6 mb-4"><div class="card border-start-warning shadow h-100 py-2"><div class="card-body"><div class="row no-gutters align-items-center"><div class="col me-2"><div class="text-xs fw-bold text-warning text-uppercase mb-1">Pending Bookings</div><div class="h5 mb-0 fw-bold text-gray-800"><?php echo $pending_bookings; ?></div></div><div class="col-auto"><i class="bi bi-clock-history fs-2 text-black-50"></i></div></div></div></div></div>
</div>

<?php include 'admin-footer.php'; ?>
