<?php
session_start();
require_once '../../includes/db.php';

// Security check: ensure an admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $booking_id = $_POST['booking_id'] ?? 0;
    $new_status = $_POST['new_status'] ?? '';

    // A list of allowed statuses to prevent malicious input
    $allowed_statuses = ['Pending', 'Confirmed', 'Ticketed', 'Cancelled'];

    if (!empty($booking_id) && in_array($new_status, $allowed_statuses)) {
        // Prepare and execute the update
        $stmt = $conn->prepare("UPDATE ferry_bookings SET status = ? WHERE id = ?");
        $stmt->bind_param("si", $new_status, $booking_id);

        if ($stmt->execute()) {
            $_SESSION['success_message'] = "Ferry Booking #$booking_id status updated to '$new_status'.";
        } else {
            $_SESSION['error_message'] = "Failed to update ferry booking status.";
        }
        $stmt->close();
    } else {
        $_SESSION['error_message'] = "Invalid data provided.";
    }
}

// Redirect back to the ferry bookings page
header("Location: ../ferry-bookings.php");
exit();
